
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A placeholder in the schema to allow for additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateTPA_Extensions_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:CustomerValueScoreType" name="CustomerValueScore" minOccurs="0"/>
 *     &lt;xs:element type="ns:SabreCorporateTravelPolicyType" name="SabreCorporateTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:SabreTravelPolicyType" name="SabreTravelPolicy" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateTPAExtensionsType implements Serializable
{
    private List<PriorityRemarksType> priorityRemarkList = new ArrayList<PriorityRemarksType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<SSRType> SSRList = new ArrayList<SSRType>();
    private List<OSIType> OSIList = new ArrayList<OSIType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList = new ArrayList<BusinessSystemIdentityInfoType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private List<STARDataType> STARDataList = new ArrayList<STARDataType>();
    private CustomerValueScoreType customerValueScore;
    private SabreCorporateTravelPolicyType sabreCorporateTravelPolicy;
    private SabreTravelPolicyType sabreTravelPolicy;

    /** 
     * Get the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return list
     */
    public List<PriorityRemarksType> getPriorityRemarkList() {
        return priorityRemarkList;
    }

    /** 
     * Set the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param list
     */
    public void setPriorityRemarkList(List<PriorityRemarksType> list) {
        priorityRemarkList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return list
     */
    public List<SSRType> getSSRList() {
        return SSRList;
    }

    /** 
     * Set the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param list
     */
    public void setSSRList(List<SSRType> list) {
        SSRList = list;
    }

    /** 
     * Get the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return list
     */
    public List<OSIType> getOSIList() {
        return OSIList;
    }

    /** 
     * Set the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param list
     */
    public void setOSIList(List<OSIType> list) {
        OSIList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @return list
     */
    public List<BusinessSystemIdentityInfoType> getBusinessSystemIdentityInfoList() {
        return businessSystemIdentityInfoList;
    }

    /** 
     * Set the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @param list
     */
    public void setBusinessSystemIdentityInfoList(
            List<BusinessSystemIdentityInfoType> list) {
        businessSystemIdentityInfoList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return list
     */
    public List<STARDataType> getSTARDataList() {
        return STARDataList;
    }

    /** 
     * Set the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param list
     */
    public void setSTARDataList(List<STARDataType> list) {
        STARDataList = list;
    }

    /** 
     * Get the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @return value
     */
    public CustomerValueScoreType getCustomerValueScore() {
        return customerValueScore;
    }

    /** 
     * Set the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @param customerValueScore
     */
    public void setCustomerValueScore(CustomerValueScoreType customerValueScore) {
        this.customerValueScore = customerValueScore;
    }

    /** 
     * Get the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreCorporateTravelPolicyType getSabreCorporateTravelPolicy() {
        return sabreCorporateTravelPolicy;
    }

    /** 
     * Set the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @param sabreCorporateTravelPolicy
     */
    public void setSabreCorporateTravelPolicy(
            SabreCorporateTravelPolicyType sabreCorporateTravelPolicy) {
        this.sabreCorporateTravelPolicy = sabreCorporateTravelPolicy;
    }

    /** 
     * Get the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreTravelPolicyType getSabreTravelPolicy() {
        return sabreTravelPolicy;
    }

    /** 
     * Set the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @param sabreTravelPolicy
     */
    public void setSabreTravelPolicy(SabreTravelPolicyType sabreTravelPolicy) {
        this.sabreTravelPolicy = sabreTravelPolicy;
    }
}
