
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Travel Agency Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateTravelAgencyProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AgencyContactNameType" name="AgencyContactName" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:AgencyInfoType" name="AgencyInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:GDSType" name="GDS" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:BrandingType" name="Branding" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:PrefCollectionsType" name="PrefCollections" minOccurs="0"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:QueueAssignmentsType" name="QueueAssignments" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CommissionsType" name="Commissions" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:SabreCorporateTravelPolicyType" name="SabreCorporateTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:SabreTravelPolicyType" name="SabreTravelPolicy" minOccurs="0"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo" minOccurs="0" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateTravelAgencyProfileType implements Serializable
{
    private List<AgencyContactNameType> agencyContactNameList = new ArrayList<AgencyContactNameType>();
    private AgencyInfoType agencyInfo;
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<PaymentFormType> paymentFormList = new ArrayList<PaymentFormType>();
    private List<ContactType> emergencyContactPersonList = new ArrayList<ContactType>();
    private List<GDSType> GDSList = new ArrayList<GDSType>();
    private List<BrandingType> brandingList = new ArrayList<BrandingType>();
    private List<PriorityRemarksType> priorityRemarkList = new ArrayList<PriorityRemarksType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList = new ArrayList<BusinessSystemIdentityInfoType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private PrefCollectionsType prefCollections;
    private List<STARDataType> STARDataList = new ArrayList<STARDataType>();
    private List<QueueAssignmentsType> queueAssignmentList = new ArrayList<QueueAssignmentsType>();
    private List<CommissionsType> commissionList = new ArrayList<CommissionsType>();
    private SabreCorporateTravelPolicyType sabreCorporateTravelPolicy;
    private SabreTravelPolicyType sabreTravelPolicy;
    private List<EmploymentInfoType> employmentInfoList = new ArrayList<EmploymentInfoType>();

    /** 
     * Get the list of 'AgencyContactName' element items. ***SABRE ADDED*** Agency Contact Information 
     * 
     * @return list
     */
    public List<AgencyContactNameType> getAgencyContactNameList() {
        return agencyContactNameList;
    }

    /** 
     * Set the list of 'AgencyContactName' element items. ***SABRE ADDED*** Agency Contact Information 
     * 
     * @param list
     */
    public void setAgencyContactNameList(List<AgencyContactNameType> list) {
        agencyContactNameList = list;
    }

    /** 
     * Get the 'AgencyInfo' element value. ***SABRE ADDED*** Agency Information
     * 
     * @return value
     */
    public AgencyInfoType getAgencyInfo() {
        return agencyInfo;
    }

    /** 
     * Set the 'AgencyInfo' element value. ***SABRE ADDED*** Agency Information
     * 
     * @param agencyInfo
     */
    public void setAgencyInfo(AgencyInfoType agencyInfo) {
        this.agencyInfo = agencyInfo;
    }

    /** 
     * Get the list of 'Address' element items. *** SABRE ADDED *** Agency Address Information
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. *** SABRE ADDED *** Agency Address Information
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. *** SABRE ADDED *** Agency Telephone Information
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. *** SABRE ADDED *** Agency Telephone Information
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ** SABRE ADDED *** Agency Email Information 
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ** SABRE ADDED *** Agency Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. *** SABRE ADDED*** Payment Information 
     * 
     * @return list
     */
    public List<PaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. *** SABRE ADDED*** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<PaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return list
     */
    public List<ContactType> getEmergencyContactPersonList() {
        return emergencyContactPersonList;
    }

    /** 
     * Set the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param list
     */
    public void setEmergencyContactPersonList(List<ContactType> list) {
        emergencyContactPersonList = list;
    }

    /** 
     * Get the list of 'GDS' element items. ***SABRE ADDED*** GDS Information associated with an Agency
     * 
     * @return list
     */
    public List<GDSType> getGDSList() {
        return GDSList;
    }

    /** 
     * Set the list of 'GDS' element items. ***SABRE ADDED*** GDS Information associated with an Agency
     * 
     * @param list
     */
    public void setGDSList(List<GDSType> list) {
        GDSList = list;
    }

    /** 
     * Get the list of 'Branding' element items. ***SABRE ADDED *** Agency Branding Informaion
     * 
     * @return list
     */
    public List<BrandingType> getBrandingList() {
        return brandingList;
    }

    /** 
     * Set the list of 'Branding' element items. ***SABRE ADDED *** Agency Branding Informaion
     * 
     * @param list
     */
    public void setBrandingList(List<BrandingType> list) {
        brandingList = list;
    }

    /** 
     * Get the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return list
     */
    public List<PriorityRemarksType> getPriorityRemarkList() {
        return priorityRemarkList;
    }

    /** 
     * Set the list of 'PriorityRemarks' element items. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param list
     */
    public void setPriorityRemarkList(List<PriorityRemarksType> list) {
        priorityRemarkList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @return list
     */
    public List<BusinessSystemIdentityInfoType> getBusinessSystemIdentityInfoList() {
        return businessSystemIdentityInfoList;
    }

    /** 
     * Set the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @param list
     */
    public void setBusinessSystemIdentityInfoList(
            List<BusinessSystemIdentityInfoType> list) {
        businessSystemIdentityInfoList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @return value
     */
    public PrefCollectionsType getPrefCollections() {
        return prefCollections;
    }

    /** 
     * Set the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @param prefCollections
     */
    public void setPrefCollections(PrefCollectionsType prefCollections) {
        this.prefCollections = prefCollections;
    }

    /** 
     * Get the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return list
     */
    public List<STARDataType> getSTARDataList() {
        return STARDataList;
    }

    /** 
     * Set the list of 'STARData' element items. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param list
     */
    public void setSTARDataList(List<STARDataType> list) {
        STARDataList = list;
    }

    /** 
     * Get the list of 'QueueAssignments' element items. *** SABRE ADDED *** Queue Assignments
     * 
     * @return list
     */
    public List<QueueAssignmentsType> getQueueAssignmentList() {
        return queueAssignmentList;
    }

    /** 
     * Set the list of 'QueueAssignments' element items. *** SABRE ADDED *** Queue Assignments
     * 
     * @param list
     */
    public void setQueueAssignmentList(List<QueueAssignmentsType> list) {
        queueAssignmentList = list;
    }

    /** 
     * Get the list of 'Commissions' element items. *** SABRE ADDED *** Commissions
     * 
     * @return list
     */
    public List<CommissionsType> getCommissionList() {
        return commissionList;
    }

    /** 
     * Set the list of 'Commissions' element items. *** SABRE ADDED *** Commissions
     * 
     * @param list
     */
    public void setCommissionList(List<CommissionsType> list) {
        commissionList = list;
    }

    /** 
     * Get the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreCorporateTravelPolicyType getSabreCorporateTravelPolicy() {
        return sabreCorporateTravelPolicy;
    }

    /** 
     * Set the 'SabreCorporateTravelPolicy' element value. *** SABRE ADDED *** Sabre Old Corporate Travel Policy Policies Information 
     * 
     * @param sabreCorporateTravelPolicy
     */
    public void setSabreCorporateTravelPolicy(
            SabreCorporateTravelPolicyType sabreCorporateTravelPolicy) {
        this.sabreCorporateTravelPolicy = sabreCorporateTravelPolicy;
    }

    /** 
     * Get the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @return value
     */
    public SabreTravelPolicyType getSabreTravelPolicy() {
        return sabreTravelPolicy;
    }

    /** 
     * Set the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @param sabreTravelPolicy
     */
    public void setSabreTravelPolicy(SabreTravelPolicyType sabreTravelPolicy) {
        this.sabreTravelPolicy = sabreTravelPolicy;
    }

    /** 
     * Get the list of 'EmploymentInfo' element items. *** SABRE ADDED *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return list
     */
    public List<EmploymentInfoType> getEmploymentInfoList() {
        return employmentInfoList;
    }

    /** 
     * Set the list of 'EmploymentInfo' element items. *** SABRE ADDED *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param list
     */
    public void setEmploymentInfoList(List<EmploymentInfoType> list) {
        employmentInfoList = list;
    }
}
