
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Root element for Template content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TemplateProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:TemplateAssociatedFiltersType" name="AssociatedFilters" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element type="ns:TemplateAssociatedFormatsType" name="AssociatedFormats" minOccurs="0" maxOccurs="500"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TemplateDescription"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="TemplateTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="CreateDateTime"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="UpdateDateTime"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="U" name="SuperTemplateIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="U" name="DefaultIndicator"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" name="TemplateStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TemplatePurgeNoOfDays"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateType implements Serializable
{
    private TemplateProfileType profile;
    private List<AssociatedProfilesType> associatedProfileList = new ArrayList<AssociatedProfilesType>();
    private List<TemplateAssociatedFiltersType> associatedFilterList = new ArrayList<TemplateAssociatedFiltersType>();
    private List<TemplateAssociatedFormatsType> associatedFormatList = new ArrayList<TemplateAssociatedFormatsType>();
    private String templateID;
    private String domainID;
    private String templateName;
    private String templateDescription;
    private ProfileTypeInfo templateTypeCode;
    private String clientCode;
    private String clientContextCode;
    private Date createDateTime;
    private Date updateDateTime;
    private YesNoType superTemplateIndicator;
    private YesNoType defaultIndicator;
    private StatusType templateStatusCode;
    private String templatePurgeNoOfDays;

    /** 
     * Get the 'Profile' element value. *** SABRE Based *** Template Strucutre of a profile data 
     * 
     * @return value
     */
    public TemplateProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** SABRE Based *** Template Strucutre of a profile data 
     * 
     * @param profile
     */
    public void setProfile(TemplateProfileType profile) {
        this.profile = profile;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Profiles Associated to a Template
     * 
     * @return list
     */
    public List<AssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Profiles Associated to a Template
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<AssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'AssociatedFilters' element items. *** SABRE ADDED *** Information about Filters associated with a template 
     * 
     * @return list
     */
    public List<TemplateAssociatedFiltersType> getAssociatedFilterList() {
        return associatedFilterList;
    }

    /** 
     * Set the list of 'AssociatedFilters' element items. *** SABRE ADDED *** Information about Filters associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFilterList(List<TemplateAssociatedFiltersType> list) {
        associatedFilterList = list;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<TemplateAssociatedFormatsType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(List<TemplateAssociatedFormatsType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the 'TemplateID' attribute value. *** SABRE ADDED *** ID of the template in the database
     * 
     * @return value
     */
    public String getTemplateID() {
        return templateID;
    }

    /** 
     * Set the 'TemplateID' attribute value. *** SABRE ADDED *** ID of the template in the database
     * 
     * @param templateID
     */
    public void setTemplateID(String templateID) {
        this.templateID = templateID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'TemplateName' attribute value.
     * 
     * @return value
     */
    public String getTemplateName() {
        return templateName;
    }

    /** 
     * Set the 'TemplateName' attribute value.
     * 
     * @param templateName
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    /** 
     * Get the 'TemplateDescription' attribute value.
     * 
     * @return value
     */
    public String getTemplateDescription() {
        return templateDescription;
    }

    /** 
     * Set the 'TemplateDescription' attribute value.
     * 
     * @param templateDescription
     */
    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    /** 
     * Get the 'TemplateTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getTemplateTypeCode() {
        return templateTypeCode;
    }

    /** 
     * Set the 'TemplateTypeCode' attribute value.
     * 
     * @param templateTypeCode
     */
    public void setTemplateTypeCode(ProfileTypeInfo templateTypeCode) {
        this.templateTypeCode = templateTypeCode;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'SuperTemplateIndicator' attribute value. Identifes whether this template is the Super Template for an agency.
     * 
     * @return value
     */
    public YesNoType getSuperTemplateIndicator() {
        return superTemplateIndicator;
    }

    /** 
     * Set the 'SuperTemplateIndicator' attribute value. Identifes whether this template is the Super Template for an agency.
     * 
     * @param superTemplateIndicator
     */
    public void setSuperTemplateIndicator(YesNoType superTemplateIndicator) {
        this.superTemplateIndicator = superTemplateIndicator;
    }

    /** 
     * Get the 'DefaultIndicator' attribute value. Identifes whether this template is the default agency.
     * 
     * @return value
     */
    public YesNoType getDefaultIndicator() {
        return defaultIndicator;
    }

    /** 
     * Set the 'DefaultIndicator' attribute value. Identifes whether this template is the default agency.
     * 
     * @param defaultIndicator
     */
    public void setDefaultIndicator(YesNoType defaultIndicator) {
        this.defaultIndicator = defaultIndicator;
    }

    /** 
     * Get the 'TemplateStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getTemplateStatusCode() {
        return templateStatusCode;
    }

    /** 
     * Set the 'TemplateStatusCode' attribute value.
     * 
     * @param templateStatusCode
     */
    public void setTemplateStatusCode(StatusType templateStatusCode) {
        this.templateStatusCode = templateStatusCode;
    }

    /** 
     * Get the 'TemplatePurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @return value
     */
    public String getTemplatePurgeNoOfDays() {
        return templatePurgeNoOfDays;
    }

    /** 
     * Set the 'TemplatePurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @param templatePurgeNoOfDays
     */
    public void setTemplatePurgeNoOfDays(String templatePurgeNoOfDays) {
        this.templatePurgeNoOfDays = templatePurgeNoOfDays;
    }
}
