
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemporaryFilterPathType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileToPNRProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:TemporaryFilterType" name="Filter"/>
 *     &lt;xs:element type="ns:ProfileToPNRTmpFltPathAssociatedFormatType" name="AssociatedFormats" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element type="ns:FilterAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="500"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemporaryFilterPathType implements Serializable
{
    private ProfileToPNRProfileType profile;
    private TemporaryFilterType filter;
    private List<ProfileToPNRTmpFltPathAssociatedFormatType> associatedFormatList = new ArrayList<ProfileToPNRTmpFltPathAssociatedFormatType>();
    private List<FilterAssociatedProfilesType> associatedProfileList = new ArrayList<FilterAssociatedProfilesType>();

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public ProfileToPNRProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(ProfileToPNRProfileType profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'Filter' element value.
     * 
     * @return value
     */
    public TemporaryFilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value.
     * 
     * @param filter
     */
    public void setFilter(TemporaryFilterType filter) {
        this.filter = filter;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<ProfileToPNRTmpFltPathAssociatedFormatType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(
            List<ProfileToPNRTmpFltPathAssociatedFormatType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items.
     * 
     * @return list
     */
    public List<FilterAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items.
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<FilterAssociatedProfilesType> list) {
        associatedProfileList = list;
    }
}
