
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Needs of the traveler related to travel experiences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerPrefCollectionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AirlinePrefType" name="AirlinePref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TravelerHotelPrefType" name="HotelPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:VehicleRentalPrefType" name="VehicleRentalPref" minOccurs="0" maxOccurs="200">
 *       &lt;xs:unique name="travelerVehicleEquipmentCodeUniqueness">
 *         &lt;xs:selector xpath="./p3:VehicleEquipment"/>
 *         &lt;xs:field xpath="@EquipmentCode"/>
 *       &lt;/xs:unique>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:RailPrefType" name="RailPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:GroundTransportationPrefType" name="GroundTransportationPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TPA_MarketingPreferenceType" name="TPA_MarketingPreference" minOccurs="0"/>
 *     &lt;xs:element type="ns:LoungePrefType" name="LoungePref" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerPrefCollectionsType implements Serializable
{
    private List<AirlinePrefType> airlinePrefList = new ArrayList<AirlinePrefType>();
    private List<TravelerHotelPrefType> hotelPrefList = new ArrayList<TravelerHotelPrefType>();
    private List<VehicleRentalPrefType> vehicleRentalPrefList = new ArrayList<VehicleRentalPrefType>();
    private List<RailPrefType> railPrefList = new ArrayList<RailPrefType>();
    private List<GroundTransportationPrefType> groundTransportationPrefList = new ArrayList<GroundTransportationPrefType>();
    private TPAMarketingPreferenceType TPAMarketingPreference;
    private List<LoungePrefType> loungePrefList = new ArrayList<LoungePrefType>();

    /** 
     * Get the list of 'AirlinePref' element items. ***OTA Based *** Airline Preference Information 
     * 
     * @return list
     */
    public List<AirlinePrefType> getAirlinePrefList() {
        return airlinePrefList;
    }

    /** 
     * Set the list of 'AirlinePref' element items. ***OTA Based *** Airline Preference Information 
     * 
     * @param list
     */
    public void setAirlinePrefList(List<AirlinePrefType> list) {
        airlinePrefList = list;
    }

    /** 
     * Get the list of 'HotelPref' element items. ***OTA Based *** Hotel Preference Information 
     * 
     * @return list
     */
    public List<TravelerHotelPrefType> getHotelPrefList() {
        return hotelPrefList;
    }

    /** 
     * Set the list of 'HotelPref' element items. ***OTA Based *** Hotel Preference Information 
     * 
     * @param list
     */
    public void setHotelPrefList(List<TravelerHotelPrefType> list) {
        hotelPrefList = list;
    }

    /** 
     * Get the list of 'VehicleRentalPref' element items. ***OTA Based *** Vehicle Preference Information 
     * 
     * @return list
     */
    public List<VehicleRentalPrefType> getVehicleRentalPrefList() {
        return vehicleRentalPrefList;
    }

    /** 
     * Set the list of 'VehicleRentalPref' element items. ***OTA Based *** Vehicle Preference Information 
     * 
     * @param list
     */
    public void setVehicleRentalPrefList(List<VehicleRentalPrefType> list) {
        vehicleRentalPrefList = list;
    }

    /** 
     * Get the list of 'RailPref' element items. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @return list
     */
    public List<RailPrefType> getRailPrefList() {
        return railPrefList;
    }

    /** 
     * Set the list of 'RailPref' element items. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @param list
     */
    public void setRailPrefList(List<RailPrefType> list) {
        railPrefList = list;
    }

    /** 
     * Get the list of 'GroundTransportationPref' element items. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @return list
     */
    public List<GroundTransportationPrefType> getGroundTransportationPrefList() {
        return groundTransportationPrefList;
    }

    /** 
     * Set the list of 'GroundTransportationPref' element items. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @param list
     */
    public void setGroundTransportationPrefList(
            List<GroundTransportationPrefType> list) {
        groundTransportationPrefList = list;
    }

    /** 
     * Get the 'TPA_MarketingPreference' element value. *** SABRE ADDED *** Marketing Preference, additional elements and attributes to be included if required, per Trading Partner Agreement (TPA)
     * 
     * @return value
     */
    public TPAMarketingPreferenceType getTPAMarketingPreference() {
        return TPAMarketingPreference;
    }

    /** 
     * Set the 'TPA_MarketingPreference' element value. *** SABRE ADDED *** Marketing Preference, additional elements and attributes to be included if required, per Trading Partner Agreement (TPA)
     * 
     * @param TPAMarketingPreference
     */
    public void setTPAMarketingPreference(
            TPAMarketingPreferenceType TPAMarketingPreference) {
        this.TPAMarketingPreference = TPAMarketingPreference;
    }

    /** 
     * Get the list of 'LoungePref' element items. ***SABRE ADDED *** Lounge Preference Information
     * 
     * @return list
     */
    public List<LoungePrefType> getLoungePrefList() {
        return loungePrefList;
    }

    /** 
     * Set the list of 'LoungePref' element items. ***SABRE ADDED *** Lounge Preference Information
     * 
     * @param list
     */
    public void setLoungePrefList(List<LoungePrefType> list) {
        loungePrefList = list;
    }
}
