
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * *** SABRE ADDED *** Used to update entries in the Dictionary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateDictionaryType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:DictionaryType" name="FullUpdate"/>
 *     &lt;xs:element type="ns:PartialUpdateDictionaryType" name="PartialUpdate"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdateDictionaryType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_UPDATE_CHOICE = 0;
    private static final int PARTIAL_UPDATE_CHOICE = 1;
    private DictionaryType fullUpdate;
    private PartialUpdateDictionaryType partialUpdate;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullUpdate() {
        return choiceSelect == FULL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'FullUpdate' element value. *** SABRE ADDED *** Used to update all entries in the Dictionary
     * 
     * @return value
     */
    public DictionaryType getFullUpdate() {
        return fullUpdate;
    }

    /** 
     * Set the 'FullUpdate' element value. *** SABRE ADDED *** Used to update all entries in the Dictionary
     * 
     * @param fullUpdate
     */
    public void setFullUpdate(DictionaryType fullUpdate) {
        setChoiceSelect(FULL_UPDATE_CHOICE);
        this.fullUpdate = fullUpdate;
    }

    /** 
     * Check if PartialUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPartialUpdate() {
        return choiceSelect == PARTIAL_UPDATE_CHOICE;
    }

    /** 
     * Get the 'PartialUpdate' element value. *** SABRE ADDED *** Used to update subset of Dictionary entries
     * 
     * @return value
     */
    public PartialUpdateDictionaryType getPartialUpdate() {
        return partialUpdate;
    }

    /** 
     * Set the 'PartialUpdate' element value. *** SABRE ADDED *** Used to update subset of Dictionary entries
     * 
     * @param partialUpdate
     */
    public void setPartialUpdate(PartialUpdateDictionaryType partialUpdate) {
        setChoiceSelect(PARTIAL_UPDATE_CHOICE);
        this.partialUpdate = partialUpdate;
    }
}
