
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatorIdentityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ValidatorIDType">
 *       &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ValidatorName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatorIdentityType extends ValidatorIDType implements
    Serializable
{
    private String clientContextCode;
    private ProfileTypeInfo profileTypeCode;
    private String validatorName;

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications Ex: MYS, EXT, NTC
    			
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications Ex: MYS, EXT, NTC
    			
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. Profile Type code of Profile this Validator binded to
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. Profile Type code of Profile this Validator binded to
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ValidatorName' attribute value. Name of the validator
     * 
     * @return value
     */
    public String getValidatorName() {
        return validatorName;
    }

    /** 
     * Set the 'ValidatorName' attribute value. Name of the validator
     * 
     * @param validatorName
     */
    public void setValidatorName(String validatorName) {
        this.validatorName = validatorName;
    }
}
