
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatorRuleType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element name="RegexpRule" minOccurs="0" maxOccurs="5">
 *       &lt;!-- Reference to inner class RegexpRule -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PredefinedRule" minOccurs="0" maxOccurs="5">
 *       &lt;!-- Reference to inner class PredefinedRule -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="XPath"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatorRuleType implements Serializable
{
    private Choice choice;
    private List<RegexpRule> regexpRuleList = new ArrayList<RegexpRule>();
    private List<PredefinedRule> predefinedRuleList = new ArrayList<PredefinedRule>();
    private String XPath;

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the list of 'RegexpRule' element items.
     * 
     * @return list
     */
    public List<RegexpRule> getRegexpRuleList() {
        return regexpRuleList;
    }

    /** 
     * Set the list of 'RegexpRule' element items.
     * 
     * @param list
     */
    public void setRegexpRuleList(List<RegexpRule> list) {
        regexpRuleList = list;
    }

    /** 
     * Get the list of 'PredefinedRule' element items.
     * 
     * @return list
     */
    public List<PredefinedRule> getPredefinedRuleList() {
        return predefinedRuleList;
    }

    /** 
     * Set the list of 'PredefinedRule' element items.
     * 
     * @param list
     */
    public void setPredefinedRuleList(List<PredefinedRule> list) {
        predefinedRuleList = list;
    }

    /** 
     * Get the 'XPath' attribute value. XPath expression for Profile element which will be validated
     * 
     * @return value
     */
    public String getXPath() {
        return XPath;
    }

    /** 
     * Set the 'XPath' attribute value. XPath expression for Profile element which will be validated
     * 
     * @param XPath
     */
    public void setXPath(String XPath) {
        this.XPath = XPath;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:RestrictionType" name="Restriction" minOccurs="0"/>
     *   &lt;xs:element name="OccurrenceRule" minOccurs="0">
     *     &lt;!-- Reference to inner class OccurrenceRule -->
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int RESTRICTION_CHOICE = 0;
        private static final int OCCURRENCE_RULE_CHOICE = 1;
        private RestrictionType restriction;
        private OccurrenceRule occurrenceRule;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Restriction is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRestriction() {
            return choiceSelect == RESTRICTION_CHOICE;
        }

        /** 
         * Get the 'Restriction' element value. Type of  restriction for Profile element: RQ - Required, OP - Optional, NA - Not Allowed
         * 
         * @return value
         */
        public RestrictionType getRestriction() {
            return restriction;
        }

        /** 
         * Set the 'Restriction' element value. Type of  restriction for Profile element: RQ - Required, OP - Optional, NA - Not Allowed
         * 
         * @param restriction
         */
        public void setRestriction(RestrictionType restriction) {
            setChoiceSelect(RESTRICTION_CHOICE);
            this.restriction = restriction;
        }

        /** 
         * Check if OccurrenceRule is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOccurrenceRule() {
            return choiceSelect == OCCURRENCE_RULE_CHOICE;
        }

        /** 
         * Get the 'OccurrenceRule' element value.
         * 
         * @return value
         */
        public OccurrenceRule getOccurrenceRule() {
            return occurrenceRule;
        }

        /** 
         * Set the 'OccurrenceRule' element value.
         * 
         * @param occurrenceRule
         */
        public void setOccurrenceRule(OccurrenceRule occurrenceRule) {
            setChoiceSelect(OCCURRENCE_RULE_CHOICE);
            this.occurrenceRule = occurrenceRule;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OccurrenceRule" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="MinOcc"/>
         *     &lt;xs:attribute type="xs:string" name="MaxOcc"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OccurrenceRule implements Serializable
        {
            private String minOcc;
            private String maxOcc;

            /** 
             * Get the 'MinOcc' attribute value. Minimal number of occurences of validated element
             * 
             * @return value
             */
            public String getMinOcc() {
                return minOcc;
            }

            /** 
             * Set the 'MinOcc' attribute value. Minimal number of occurences of validated element
             * 
             * @param minOcc
             */
            public void setMinOcc(String minOcc) {
                this.minOcc = minOcc;
            }

            /** 
             * Get the 'MaxOcc' attribute value. Maximal number of occurences of validated element
             * 
             * @return value
             */
            public String getMaxOcc() {
                return maxOcc;
            }

            /** 
             * Set the 'MaxOcc' attribute value. Maximal number of occurences of validated element
             * 
             * @param maxOcc
             */
            public void setMaxOcc(String maxOcc) {
                this.maxOcc = maxOcc;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RegexpRule" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Regexp"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RegexpRule implements Serializable
    {
        private String regexp;

        /** 
         * Get the 'Regexp' attribute value. Regular expression against which Profile element will be validated
         * 
         * @return value
         */
        public String getRegexp() {
            return regexp;
        }

        /** 
         * Set the 'Regexp' attribute value. Regular expression against which Profile element will be validated
         * 
         * @param regexp
         */
        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PredefinedRule" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="RuleParam" minOccurs="0" maxOccurs="10">
     *         &lt;!-- Reference to inner class RuleParam -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="ValidatorCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PredefinedRule implements Serializable
    {
        private List<RuleParam> ruleParamList = new ArrayList<RuleParam>();
        private String validatorCode;

        /** 
         * Get the list of 'RuleParam' element items.
         * 
         * @return list
         */
        public List<RuleParam> getRuleParamList() {
            return ruleParamList;
        }

        /** 
         * Set the list of 'RuleParam' element items.
         * 
         * @param list
         */
        public void setRuleParamList(List<RuleParam> list) {
            ruleParamList = list;
        }

        /** 
         * Get the 'ValidatorCode' attribute value. Name of predefined custom function which will be called to validate Profile element
         * 
         * @return value
         */
        public String getValidatorCode() {
            return validatorCode;
        }

        /** 
         * Set the 'ValidatorCode' attribute value. Name of predefined custom function which will be called to validate Profile element
         * 
         * @param validatorCode
         */
        public void setValidatorCode(String validatorCode) {
            this.validatorCode = validatorCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleParam" minOccurs="0" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RuleParam implements Serializable
        {
            private String name;
            private String value;

            /** 
             * Get the 'Name' attribute value. Name of parameter of custom function which will be passed to it
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value. Name of parameter of custom function which will be passed to it
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Value' attribute value. Value of parameter of custom function which will be passed to it
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Value of parameter of custom function which will be passed to it
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}
