
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Vehicle equipment preferred by traveler.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleEquipmentType">
 *   &lt;xs:attribute type="xs:string" use="required" name="EquipmentCode"/>
 *   &lt;xs:attribute type="xs:string" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicleEquipmentType implements Serializable
{
    private String equipmentCode;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'EquipmentCode' attribute value. Equipment Code
     * 
     * @return value
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /** 
     * Set the 'EquipmentCode' attribute value. Equipment Code
     * 
     * @param equipmentCode
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
