
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Vehicle rental preferences can be specified for customers or companies to indicate their preferences for types of vehicles to be rented in specific travel situations. Companies may wish to specify certain class or types of cars that their employees are allowed to rent, or indicate special business needs for trucks for hauling goods, etc. Personal travelers may wish to indicate preferences for types of vehicles such as vans or SUVs for family vacations, or smaller, more sporty models when travelling alone. A customer may prefer to have a convertible or sun roof in a warm destination, but request a ski rack when vacationing in the wintertime.   The VehicleProfileRentalPrefType complex type has elements for specific features on rental cars including vehicle type (major category such as car, truck, SUV) and vehicle class (more precise kind of vehicle), air conditioning, transmission, and special equipment. In addition, the specification captures preferences for vendors and loyalty programs, insurance coverage, forms of payment for rental cars, and other special requirements. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleRentalPrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PreferredVehicleVendorsType" name="PreferredVehicleVendors" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *     &lt;xs:element type="ns:VehicleEquipmentType" name="VehicleEquipment" minOccurs="0" maxOccurs="10"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicleRentalPrefType implements Serializable
{
    private List<PreferredVehicleVendorsType> preferredVehicleVendorList = new ArrayList<PreferredVehicleVendorsType>();
    private List<PreferredAggregatorType> preferredAggregatorList = new ArrayList<PreferredAggregatorType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private List<VehicleEquipmentType> vehicleEquipmentList = new ArrayList<VehicleEquipmentType>();
    private String tripTypeCode;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String informationText;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the list of 'PreferredVehicleVendors' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @return list
     */
    public List<PreferredVehicleVendorsType> getPreferredVehicleVendorList() {
        return preferredVehicleVendorList;
    }

    /** 
     * Set the list of 'PreferredVehicleVendors' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @param list
     */
    public void setPreferredVehicleVendorList(
            List<PreferredVehicleVendorsType> list) {
        preferredVehicleVendorList = list;
    }

    /** 
     * Get the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return list
     */
    public List<PreferredAggregatorType> getPreferredAggregatorList() {
        return preferredAggregatorList;
    }

    /** 
     * Set the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param list
     */
    public void setPreferredAggregatorList(List<PreferredAggregatorType> list) {
        preferredAggregatorList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the list of 'VehicleEquipment' element items. *** SABRE ADDED *** Vehicle Equipment Information
     * 
     * @return list
     */
    public List<VehicleEquipmentType> getVehicleEquipmentList() {
        return vehicleEquipmentList;
    }

    /** 
     * Set the list of 'VehicleEquipment' element items. *** SABRE ADDED *** Vehicle Equipment Information
     * 
     * @param list
     */
    public void setVehicleEquipmentList(List<VehicleEquipmentType> list) {
        vehicleEquipmentList = list;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
