
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicleTypeInfoType">
 *   &lt;xs:choice minOccurs="0">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicleTypeInfoType implements Serializable
{
    private Choice choice;

    /** 
     * Get the 'VehicleTypeInfoType' complexType value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the 'VehicleTypeInfoType' complexType value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:VehicleMatrixTypeInfoType" name="MatrixType" minOccurs="0"/>
     *   &lt;xs:element type="ns:VehiclePseudoTypeInfoType" name="PseudoType" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int MATRIX_TYPE_CHOICE = 0;
        private static final int PSEUDO_TYPE_CHOICE = 1;
        private VehicleMatrixTypeInfoType matrixType;
        private VehiclePseudoTypeInfoType pseudoType;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if MatrixType is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMatrixType() {
            return choiceSelect == MATRIX_TYPE_CHOICE;
        }

        /** 
         * Get the 'MatrixType' element value.
         * 
         * @return value
         */
        public VehicleMatrixTypeInfoType getMatrixType() {
            return matrixType;
        }

        /** 
         * Set the 'MatrixType' element value.
         * 
         * @param matrixType
         */
        public void setMatrixType(VehicleMatrixTypeInfoType matrixType) {
            setChoiceSelect(MATRIX_TYPE_CHOICE);
            this.matrixType = matrixType;
        }

        /** 
         * Check if PseudoType is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPseudoType() {
            return choiceSelect == PSEUDO_TYPE_CHOICE;
        }

        /** 
         * Get the 'PseudoType' element value.
         * 
         * @return value
         */
        public VehiclePseudoTypeInfoType getPseudoType() {
            return pseudoType;
        }

        /** 
         * Set the 'PseudoType' element value.
         * 
         * @param pseudoType
         */
        public void setPseudoType(VehiclePseudoTypeInfoType pseudoType) {
            setChoiceSelect(PSEUDO_TYPE_CHOICE);
            this.pseudoType = pseudoType;
        }
    }
}
