
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.AdditionalPricingStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AUTO PRICED"/>
 *     &lt;xs:enumeration value="MANUAL"/>
 *     &lt;xs:enumeration value="RATE DESK"/>
 *     &lt;xs:enumeration value="WARNING"/>
 *     &lt;xs:enumeration value="AMENDMENTS"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeAdditionalPricingStatus implements Serializable {
    AUTOPRICED("AUTO PRICED"), MANUAL("MANUAL"), RATEDESK("RATE DESK"), WARNING(
            "WARNING"), AMENDMENTS("AMENDMENTS");
    private final String value;

    private CodeAdditionalPricingStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeAdditionalPricingStatus convert(String value) {
        for (CodeAdditionalPricingStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
