
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * .
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.EndorsementType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ENS"/>
 *     &lt;xs:enumeration value="END"/>
 *     &lt;xs:enumeration value="ENO"/>
 *     &lt;xs:enumeration value="EO1"/>
 *     &lt;xs:enumeration value="EOD"/>
 *     &lt;xs:enumeration value="RES"/>
 *     &lt;xs:enumeration value="ERR"/>
 *     &lt;xs:enumeration value="RTE"/>
 *     &lt;xs:enumeration value="MSK"/>
 *     &lt;xs:enumeration value="RMK"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeEndorsementType implements Serializable {
    ENS("ENS"), END("END"), ENO("ENO"), E_O1("EO1"), EOD("EOD"), RES("RES"), ERR(
            "ERR"), RTE("RTE"), MSK("MSK"), RMK("RMK");
    private final String value;

    private CodeEndorsementType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeEndorsementType convert(String value) {
        for (CodeEndorsementType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
