
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionVerification.Hierarchy">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="TicketDesignator" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="TourNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="Endorsement" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CommissionVerificationHierarchy implements Serializable
{
    private BigInteger ticketDesignator;
    private BigInteger tourNumber;
    private BigInteger endorsement;

    /** 
     * Get the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_TDH
    				
     * 
     * @return value
     */
    public BigInteger getTicketDesignator() {
        return ticketDesignator;
    }

    /** 
     * Set the 'TicketDesignator' element value. Ticket Designator hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_TDH
    				
     * 
     * @param ticketDesignator
     */
    public void setTicketDesignator(BigInteger ticketDesignator) {
        this.ticketDesignator = ticketDesignator;
    }

    /** 
     * Get the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_TCH
    				
     * 
     * @return value
     */
    public BigInteger getTourNumber() {
        return tourNumber;
    }

    /** 
     * Set the 'TourNumber' element value. Tour code hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_TCH
    				
     * 
     * @param tourNumber
     */
    public void setTourNumber(BigInteger tourNumber) {
        this.tourNumber = tourNumber;
    }

    /** 
     * Get the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_EDH
    				
     * 
     * @return value
     */
    public BigInteger getEndorsement() {
        return endorsement;
    }

    /** 
     * Set the 'Endorsement' element value. Endorsement hierarchy number as passed by Pricing

    					Ref: DM0Z_C9_CVH_EDH
    				
     * 
     * @param endorsement
     */
    public void setEndorsement(BigInteger endorsement) {
        this.endorsement = endorsement;
    }
}
