
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.CommissionDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.OtherCommission" name="OtherCommission" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="source"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareCommissionDetails implements Serializable
{
    private Amount amount;
    private BigDecimal percentage;
    private List<FareOtherCommission> otherCommissionList = new ArrayList<FareOtherCommission>();
    private String source;
    private String type;

    /** 
     * Get the 'Amount' element value. Commision amount/penalty
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Commision amount/penalty
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Percentage' element value. Commision percentage
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Commision percentage
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    /** 
     * Get the list of 'OtherCommission' element items.
     * 
     * @return list
     */
    public List<FareOtherCommission> getOtherCommissionList() {
        return otherCommissionList;
    }

    /** 
     * Set the list of 'OtherCommission' element items.
     * 
     * @param list
     */
    public void setOtherCommissionList(List<FareOtherCommission> list) {
        otherCommissionList = list;
    }

    /** 
     * Get the 'source' attribute value. AGT - Agent-entered Commission
    			
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'source' attribute value. AGT - Agent-entered Commission
    			
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'type' attribute value. S - Special promo commission
    				N - Commission percent on NET
    				G - GRT commission
    				Ref:
    				DM0Z_85_COMI
    				DM0Z_86_COMI
    				#DM0Z_85_KPN
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. S - Special promo commission
    				N - Commission percent on NET
    				G - GRT commission
    				Ref:
    				DM0Z_85_COMI
    				DM0Z_86_COMI
    				#DM0Z_85_KPN
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
