
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.CommissionVerification.Details">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ControlQualifier" minOccurs="0"/>
 *     &lt;xs:element type="ns:CommissionVerification.Hierarchy" name="Hierarchy" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VerificationCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Endorsement" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="placement"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareCommissionVerificationDetails implements Serializable
{
    private String controlQualifier;
    private CommissionVerificationHierarchy hierarchy;
    private String verificationCode;
    private String endorsement;
    private String placement;

    /** 
     * Get the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

    					Ref: DM0Z_C9_CCQ_CCOQ
    				
     * 
     * @return value
     */
    public String getControlQualifier() {
        return controlQualifier;
    }

    /** 
     * Set the 'ControlQualifier' element value. Commission controller qualifier as passed by Pricing

    					Ref: DM0Z_C9_CCQ_CCOQ
    				
     * 
     * @param controlQualifier
     */
    public void setControlQualifier(String controlQualifier) {
        this.controlQualifier = controlQualifier;
    }

    /** 
     * Get the 'Hierarchy' element value.
     * 
     * @return value
     */
    public CommissionVerificationHierarchy getHierarchy() {
        return hierarchy;
    }

    /** 
     * Set the 'Hierarchy' element value.
     * 
     * @param hierarchy
     */
    public void setHierarchy(CommissionVerificationHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    /** 
     * Get the 'VerificationCode' element value. Commission verification code as passed by Pricing

    					Ref: DM0Z_C9_TKI_CVC
    				
     * 
     * @return value
     */
    public String getVerificationCode() {
        return verificationCode;
    }

    /** 
     * Set the 'VerificationCode' element value. Commission verification code as passed by Pricing

    					Ref: DM0Z_C9_TKI_CVC
    				
     * 
     * @param verificationCode
     */
    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    /** 
     * Get the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

    					Ref: DM0Z_C9_CVH_EDMG
    				
     * 
     * @return value
     */
    public String getEndorsement() {
        return endorsement;
    }

    /** 
     * Set the 'Endorsement' element value. Commission endorsement message text as passed by Pricing

    					Ref: DM0Z_C9_CVH_EDMG
    				
     * 
     * @param endorsement
     */
    public void setEndorsement(String endorsement) {
        this.endorsement = endorsement;
    }

    /** 
     * Get the 'placement' attribute value. Commission verification placement as passed by Pricing

    				Ref: DMOZ_C9_TKI_CVP
    			
     * 
     * @return value
     */
    public String getPlacement() {
        return placement;
    }

    /** 
     * Set the 'placement' attribute value. Commission verification placement as passed by Pricing

    				Ref: DMOZ_C9_TKI_CVP
    			
     * 
     * @param placement
     */
    public void setPlacement(String placement) {
        this.placement = placement;
    }
}
