
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.HandlingFee">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount"/>
 *     &lt;xs:element name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:anySimpleType" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:boolean" name="hidden"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareHandlingFee implements Serializable
{
    private Amount amount;
    private boolean description;
    private String code;
    private String type;
    private Boolean hidden;

    /** 
     * Get the 'Amount' element value. 
    					Ref: DM0Z_CF_HND_AMNT
    				
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. 
    					Ref: DM0Z_CF_HND_AMNT
    				
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Check if the 'Description' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifDescriptionPresent() {
        return description;
    }

    /** 
     * Set flag for 'Description' element present.
     * 
     * @param description
     */
    public void flagDescriptionPresent(boolean description) {
        this.description = description;
    }

    /** 
     * Get the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

    				Possible Values:
    				A - Base Fare hidden fee
    				B - Base fare  unhidden fee

    				Ref: DM0Z_CF_ITYP
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Code associated to the specific type of handling fee as returned by Pricing

    				Possible Values:
    				A - Base Fare hidden fee
    				B - Base fare  unhidden fee

    				Ref: DM0Z_CF_ITYP
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'type' attribute value. Handling fee type based on the applicable fare
    				Possible Values:
    				BSE - Base Fare
    				PTK =Ticket Fare
    				TTL = Total Fare
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Handling fee type based on the applicable fare
    				Possible Values:
    				BSE - Base Fare
    				PTK =Ticket Fare
    				TTL = Total Fare
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
     * 
     * @return value
     */
    public Boolean getHidden() {
        return hidden;
    }

    /** 
     * Set the 'hidden' attribute value. Set to true if the fee is considered ' hidden'
     * 
     * @param hidden
     */
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }
}
