
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare.OptionalServiceInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="quantity"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareOptionalServiceInfo implements Serializable
{
    private Amount amount;
    private String description;
    private String type;
    private BigInteger quantity;
    private String code;

    /** 
     * Get the 'Amount' element value. Optional Service Amount
    					Ref: DM0Z_E7_LCC_AMT
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Optional Service Amount
    					Ref: DM0Z_E7_LCC_AMT
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Description' element value. Description of a fee item

    					Ref: DM0Z_E7_LCC_TXT
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description of a fee item

    					Ref: DM0Z_E7_LCC_TXT
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'type' attribute value. Code representing the type of optional service

    				Ref: DM0Z_E7_LCC_TYP
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Code representing the type of optional service

    				Ref: DM0Z_E7_LCC_TYP
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'quantity' attribute value. total quantity of the optional service or charge

    				Ref: DM0Z_E7_LCC_ITM
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' attribute value. total quantity of the optional service or charge

    				Ref: DM0Z_E7_LCC_ITM
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the 'code' attribute value. Code associated to optional service or charge.

    				Possible values:
    				BGAD
    				PRBD
    				SEAT
    				MEAL
    				JUMP...

    				Ref: DM0Z_E7_LCC_CHG        
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Code associated to optional service or charge.

    				Possible values:
    				BGAD
    				PRBD
    				SEAT
    				MEAL
    				JUMP...

    				Ref: DM0Z_E7_LCC_CHG        
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }
}
