
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GetResultsChoice.CG">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PriceQuote.Details" name="Details" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.CustomDetails" name="CustomDetails" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class GetResultsChoiceCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int DETAIL_LIST_CHOICE = 0;
    private static final int CUSTOM_DETAIL_LIST_CHOICE = 1;
    private List<PriceQuoteDetails> detailList = new ArrayList<PriceQuoteDetails>();
    private List<PriceQuoteCustomDetails> customDetailList = new ArrayList<PriceQuoteCustomDetails>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDetailList() {
        return choiceSelect == DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Details' element items. Price Quote details. This information is equivalent to *PQ
     * 
     * @return list
     */
    public List<PriceQuoteDetails> getDetailList() {
        return detailList;
    }

    /** 
     * Set the list of 'Details' element items. Price Quote details. This information is equivalent to *PQ
     * 
     * @param list
     */
    public void setDetailList(List<PriceQuoteDetails> list) {
        setChoiceSelect(DETAIL_LIST_CHOICE);
        detailList = list;
    }

    /** 
     * Check if CustomDetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDetailList() {
        return choiceSelect == CUSTOM_DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CustomDetails' element items. Price Quote Custom details. This information is equivalent to *PQ
     * 
     * @return list
     */
    public List<PriceQuoteCustomDetails> getCustomDetailList() {
        return customDetailList;
    }

    /** 
     * Set the list of 'CustomDetails' element items. Price Quote Custom details. This information is equivalent to *PQ
     * 
     * @param list
     */
    public void setCustomDetailList(List<PriceQuoteCustomDetails> list) {
        setChoiceSelect(CUSTOM_DETAIL_LIST_CHOICE);
        customDetailList = list;
    }
}
