
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Message.EndorsementType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="ns:Code.EndorsementType" use="required" name="type"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MessageEndorsementType implements Serializable
{
    private String string;
    private CodeEndorsementType type;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'type' attribute value. ENS - System-generated endorsement
    						END - Agent-generated endorsement
    						ENO - Endorsement override
    						EO1 - Endorsement override 1
    						EO2 -  Endorsement override 2
    						EOD  - Endorsement override with ED
    						RES -  System-generated restriction
    						RTE -  Reissue-type endorsement
    						MSK - Mask-entered endorsement
    						RMK - Mask-entered remark
    						Ref:  DM0Z_60_TYPE -
    						x' 05 - x'0F
    					
     * 
     * @return value
     */
    public CodeEndorsementType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. ENS - System-generated endorsement
    						END - Agent-generated endorsement
    						ENO - Endorsement override
    						EO1 - Endorsement override 1
    						EO2 -  Endorsement override 2
    						EOD  - Endorsement override with ED
    						RES -  System-generated restriction
    						RTE -  Reissue-type endorsement
    						MSK - Mask-entered endorsement
    						RMK - Mask-entered remark
    						Ref:  DM0Z_60_TYPE -
    						x' 05 - x'0F
    					
     * 
     * @param type
     */
    public void setType(CodeEndorsementType type) {
        this.type = type;
    }
}
