
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameAssociationAttributes">
 *   &lt;xs:attribute type="xs:string" name="nameNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="firstName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="lastName"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class NameAssociationAttributes implements Serializable
{
    private String nameNumber;
    private BigInteger nameId;
    private String firstName;
    private String lastName;

    /** 
     * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
    			
     * 
     * @return value
     */
    public String getNameNumber() {
        return nameNumber;
    }

    /** 
     * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
    			
     * 
     * @param nameNumber
     */
    public void setNameNumber(String nameNumber) {
        this.nameNumber = nameNumber;
    }

    /** 
     * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
    			
     * 
     * @return value
     */
    public BigInteger getNameId() {
        return nameId;
    }

    /** 
     * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
    			
     * 
     * @param nameId
     */
    public void setNameId(BigInteger nameId) {
        this.nameId = nameId;
    }

    /** 
     * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
    			
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
    			
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
    			
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
    			
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}
