
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.AddCollectInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="TotalAmount" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddCollect.Tax" name="Taxes" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteAddCollectInfo implements Serializable
{
    private Amount totalAmount;
    private List<AddCollectTax> taxeList = new ArrayList<AddCollectTax>();

    /** 
     * Get the 'TotalAmount' element value. Total amount collected
    					this transaction
    					For TN: Fare Diff + Ticket Fee tax
    					Ref: DM0Z_C0_TAMT + C0_TFTB
    					For AS: Fare Diff + Change Fee
     * 
     * @return value
     */
    public Amount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total amount collected
    					this transaction
    					For TN: Fare Diff + Ticket Fee tax
    					Ref: DM0Z_C0_TAMT + C0_TFTB
    					For AS: Fare Diff + Change Fee
     * 
     * @param totalAmount
     */
    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the list of 'Taxes' element items. Add collect taxes
    					applicable only for TN
     * 
     * @return list
     */
    public List<AddCollectTax> getTaxeList() {
        return taxeList;
    }

    /** 
     * Set the list of 'Taxes' element items. Add collect taxes
    					applicable only for TN
     * 
     * @param list
     */
    public void setTaxeList(List<AddCollectTax> list) {
        taxeList = list;
    }
}
