
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.CommonAssociation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Indicators" name="Indicators" minOccurs="0"/>
 *     &lt;xs:element name="Passenger" minOccurs="0">
 *       &lt;!-- Reference to inner class Passenger -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ItineraryType" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Item.Fee.CommonAssociation" name="Fee" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="TicketDesignator" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Amounts" name="Amounts" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:Message.TextType" name="MessageInfo" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Code.PQType" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
 *   &lt;xs:attribute type="xs:string" name="pricingStatus"/>
 *   &lt;xs:attribute type="xs:string" name="reissueType"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="latestPQFlag"/>
 *   &lt;xs:attribute type="xs:boolean" name="viewershipRestricted"/>
 *   &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
 *   &lt;xs:attribute type="xs:boolean" name="incompletePQR"/>
 *   &lt;xs:attribute type="xs:boolean" name="createdByOrder"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteCommonAssociation implements Serializable
{
    private PriceQuoteIndicators indicators;
    private Passenger passenger;
    private String itineraryType;
    private List<PriceQuoteItemFeeCommonAssociation> feeList = new ArrayList<PriceQuoteItemFeeCommonAssociation>();
    private List<String> ticketDesignatorList = new ArrayList<String>();
    private String validatingCarrier;
    private PriceQuoteAmounts amounts;
    private Date localCreateDateTime;
    private List<MessageTextType> messageInfoList = new ArrayList<MessageTextType>();
    private CodePQType type;
    private BigInteger number;
    private String status;
    private String pricingType;
    private String pricingStatus;
    private String reissueType;
    private Boolean latestPQFlag;
    private Boolean viewershipRestricted;
    private Boolean lowCostCarrier;
    private Boolean incompletePQR;
    private Boolean createdByOrder;

    /** 
     * Get the 'Indicators' element value. PQ indicators with boolen values; default to 'false'
    				
     * 
     * @return value
     */
    public PriceQuoteIndicators getIndicators() {
        return indicators;
    }

    /** 
     * Set the 'Indicators' element value. PQ indicators with boolen values; default to 'false'
    				
     * 
     * @param indicators
     */
    public void setIndicators(PriceQuoteIndicators indicators) {
        this.indicators = indicators;
    }

    /** 
     * Get the 'Passenger' element value.
     * 
     * @return value
     */
    public Passenger getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'Passenger' element value.
     * 
     * @param passenger
     */
    public void setPassenger(Passenger passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'ItineraryType' element value. Possible values
    					I - International
    					D- Domestic

    					Ref:DM0Z_65_ID01
     * 
     * @return value
     */
    public String getItineraryType() {
        return itineraryType;
    }

    /** 
     * Set the 'ItineraryType' element value. Possible values
    					I - International
    					D- Domestic

    					Ref:DM0Z_65_ID01
     * 
     * @param itineraryType
     */
    public void setItineraryType(String itineraryType) {
        this.itineraryType = itineraryType;
    }

    /** 
     * Get the list of 'Fee' element items. Only 50 fee items can be stored per PQ
     * 
     * @return list
     */
    public List<PriceQuoteItemFeeCommonAssociation> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items. Only 50 fee items can be stored per PQ
     * 
     * @param list
     */
    public void setFeeList(List<PriceQuoteItemFeeCommonAssociation> list) {
        feeList = list;
    }

    /** 
     * Get the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
     * 
     * @return list
     */
    public List<String> getTicketDesignatorList() {
        return ticketDesignatorList;
    }

    /** 
     * Set the list of 'TicketDesignator' element items. Code assigned by the airline/subscribers to designate specific fare discounts
     * 
     * @param list
     */
    public void setTicketDesignatorList(List<String> list) {
        ticketDesignatorList = list;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating Carrier.
    					Ref: DM0Z_65_CRXC
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating Carrier.
    					Ref: DM0Z_65_CRXC
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'Amounts' element value.
     * 
     * @return value
     */
    public PriceQuoteAmounts getAmounts() {
        return amounts;
    }

    /** 
     * Set the 'Amounts' element value.
     * 
     * @param amounts
     */
    public void setAmounts(PriceQuoteAmounts amounts) {
        this.amounts = amounts;
    }

    /** 
     * Get the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
    					Ref: SR06PQ-20_CLDB/CTIM
     * 
     * @return value
     */
    public Date getLocalCreateDateTime() {
        return localCreateDateTime;
    }

    /** 
     * Set the 'LocalCreateDateTime' element value. Local Create Date/time of  the PQ.
    					Ref: SR06PQ-20_CLDB/CTIM
     * 
     * @param localCreateDateTime
     */
    public void setLocalCreateDateTime(Date localCreateDateTime) {
        this.localCreateDateTime = localCreateDateTime;
    }

    /** 
     * Get the list of 'MessageInfo' element items.
     * 
     * @return list
     */
    public List<MessageTextType> getMessageInfoList() {
        return messageInfoList;
    }

    /** 
     * Set the list of 'MessageInfo' element items.
     * 
     * @param list
     */
    public void setMessageInfoList(List<MessageTextType> list) {
        messageInfoList = list;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @return value
     */
    public CodePQType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @param type
     */
    public void setType(CodePQType type) {
        this.type = type;
    }

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not subscriber
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
    			
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not subscriber
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
    			
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'pricingType' attribute value. Code associated to the status as to how pricing was done

    				Possible values:
    				S - System
    				M - Manual
    				A - Amended
    			
     * 
     * @return value
     */
    public String getPricingType() {
        return pricingType;
    }

    /** 
     * Set the 'pricingType' attribute value. Code associated to the status as to how pricing was done

    				Possible values:
    				S - System
    				M - Manual
    				A - Amended
    			
     * 
     * @param pricingType
     */
    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    /** 
     * Get the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @return value
     */
    public String getPricingStatus() {
        return pricingStatus;
    }

    /** 
     * Set the 'pricingStatus' attribute value. pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @param pricingStatus
     */
    public void setPricingStatus(String pricingStatus) {
        this.pricingStatus = pricingStatus;
    }

    /** 
     * Get the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
    				Possible values:
    				INVOL
    				SKED CHG
    				EXCH EVEN
    				EXCH CF
    				EXCH AC
    				EXCH AC/CF
    				EXCH RFND
    				LTA
    				AFFIDAVIT
    				LTA/CF
    				AFFIDAVIT/CF
    				REFUND
    				REFUND CF
    			
     * 
     * @return value
     */
    public String getReissueType() {
        return reissueType;
    }

    /** 
     * Set the 'reissueType' attribute value. Applicable only for a reissued PQ(PQR) and type is of "PQReissue"
    				Possible values:
    				INVOL
    				SKED CHG
    				EXCH EVEN
    				EXCH CF
    				EXCH AC
    				EXCH AC/CF
    				EXCH RFND
    				LTA
    				AFFIDAVIT
    				LTA/CF
    				AFFIDAVIT/CF
    				REFUND
    				REFUND CF
    			
     * 
     * @param reissueType
     */
    public void setReissueType(String reissueType) {
        this.reissueType = reissueType;
    }

    /** 
     * Get the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
     * 
     * @return value
     */
    public Boolean getLatestPQFlag() {
        return latestPQFlag;
    }

    /** 
     * Set the 'latestPQFlag' attribute value. This flag indicates if this is the latest PQ applicable for the Passenger. Applicable only for Associated PQ
     * 
     * @param latestPQFlag
     */
    public void setLatestPQFlag(Boolean latestPQFlag) {
        this.latestPQFlag = latestPQFlag;
    }

    /** 
     * Get the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
     * 
     * @return value
     */
    public Boolean getViewershipRestricted() {
        return viewershipRestricted;
    }

    /** 
     * Set the 'viewershipRestricted' attribute value. This flag iindicates if the PQ is viewable or restricted. Set to true when viewership is restricted.
     * 
     * @param viewershipRestricted
     */
    public void setViewershipRestricted(Boolean viewershipRestricted) {
        this.viewershipRestricted = viewershipRestricted;
    }

    /** 
     * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @return value
     */
    public Boolean getLowCostCarrier() {
        return lowCostCarrier;
    }

    /** 
     * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @param lowCostCarrier
     */
    public void setLowCostCarrier(Boolean lowCostCarrier) {
        this.lowCostCarrier = lowCostCarrier;
    }

    /** 
     * Get the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

    				REF: #DM0Z_40_PQC 
     * 
     * @return value
     */
    public Boolean getIncompletePQR() {
        return incompletePQR;
    }

    /** 
     * Set the 'incompletePQR' attribute value. Indicates PQR is not confirmed with FOP

    				REF: #DM0Z_40_PQC 
     * 
     * @param incompletePQR
     */
    public void setIncompletePQR(Boolean incompletePQR) {
        this.incompletePQR = incompletePQR;
    }

    /** 
     * Get the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
     * 
     * @return value
     */
    public Boolean getCreatedByOrder() {
        return createdByOrder;
    }

    /** 
     * Set the 'createdByOrder' attribute value. This flag indicates if PQ is created via NDC order
     * 
     * @param createdByOrder
     */
    public void setCreatedByOrder(Boolean createdByOrder) {
        this.createdByOrder = createdByOrder;
    }
    /** 
     * Passenger data related to PQ
    				
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:Passenger.Details">
     *         &lt;xs:attribute type="xs:string" name="type"/>
     *         &lt;xs:attribute type="xs:string" name="requestedType"/>
     *         &lt;xs:attribute type="xs:string" name="pricedType"/>
     *         &lt;xs:attribute type="xs:int" name="passengerTypeCount"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passenger extends PassengerDetails implements
        Serializable
    {
        private String type;
        private String requestedType;
        private String pricedType;
        private Integer passengerTypeCount;

        /** 
         * Get the 'type' attribute value. Passenger Type
        									Ref: DM0Z_40_PTCD
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. Passenger Type
        									Ref: DM0Z_40_PTCD
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'requestedType' attribute value. Input Passenger Type.
        									Ref: DM0Z_40_PTCI
         * 
         * @return value
         */
        public String getRequestedType() {
            return requestedType;
        }

        /** 
         * Set the 'requestedType' attribute value. Input Passenger Type.
        									Ref: DM0Z_40_PTCI
         * 
         * @param requestedType
         */
        public void setRequestedType(String requestedType) {
            this.requestedType = requestedType;
        }

        /** 
         * Get the 'pricedType' attribute value. Passenger Type priced.
        									Ref: DM0Z_40_TPTC
         * 
         * @return value
         */
        public String getPricedType() {
            return pricedType;
        }

        /** 
         * Set the 'pricedType' attribute value. Passenger Type priced.
        									Ref: DM0Z_40_TPTC
         * 
         * @param pricedType
         */
        public void setPricedType(String pricedType) {
            this.pricedType = pricedType;
        }

        /** 
         * Get the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
         * 
         * @return value
         */
        public Integer getPassengerTypeCount() {
            return passengerTypeCount;
        }

        /** 
         * Set the 'passengerTypeCount' attribute value. Count of passenger type in the Price Quote
         * 
         * @param passengerTypeCount
         */
        public void setPassengerTypeCount(Integer passengerTypeCount) {
            this.passengerTypeCount = passengerTypeCount;
        }
    }
}
