
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.AdditionalFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.OriginalSellingFareInfo" name="OriginalSellingFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.PublishedFareInfo" name="PublishedFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.RetailerFareInfo" name="RetailerFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NetFareInfo" name="NetFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NetRemitInfo" name="NetRemitInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NewSellingFareInfo" name="NewSellingFareinfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsAdditionalFareInfo implements Serializable
{
    private PriceQuoteDetailsOriginalSellingFareInfo originalSellingFareInfo;
    private PriceQuoteDetailsPublishedFareInfo publishedFareInfo;
    private PriceQuoteDetailsRetailerFareInfo retailerFareInfo;
    private PriceQuoteDetailsNetFareInfo netFareInfo;
    private PriceQuoteDetailsNetRemitInfo netRemitInfo;
    private PriceQuoteDetailsNewSellingFareInfo newSellingFareinfo;

    /** 
     * Get the 'OriginalSellingFareInfo' element value. Original selling fare is returned when the user is authorized to view it 
     * 
     * @return value
     */
    public PriceQuoteDetailsOriginalSellingFareInfo getOriginalSellingFareInfo() {
        return originalSellingFareInfo;
    }

    /** 
     * Set the 'OriginalSellingFareInfo' element value. Original selling fare is returned when the user is authorized to view it 
     * 
     * @param originalSellingFareInfo
     */
    public void setOriginalSellingFareInfo(
            PriceQuoteDetailsOriginalSellingFareInfo originalSellingFareInfo) {
        this.originalSellingFareInfo = originalSellingFareInfo;
    }

    /** 
     * Get the 'PublishedFareInfo' element value. Equivalent to *PQP

    					Ref: DM0Z_85_PUB 'x 01
     * 
     * @return value
     */
    public PriceQuoteDetailsPublishedFareInfo getPublishedFareInfo() {
        return publishedFareInfo;
    }

    /** 
     * Set the 'PublishedFareInfo' element value. Equivalent to *PQP

    					Ref: DM0Z_85_PUB 'x 01
     * 
     * @param publishedFareInfo
     */
    public void setPublishedFareInfo(
            PriceQuoteDetailsPublishedFareInfo publishedFareInfo) {
        this.publishedFareInfo = publishedFareInfo;
    }

    /** 
     * Get the 'RetailerFareInfo' element value. Maps to *PQ#R
     * 
     * @return value
     */
    public PriceQuoteDetailsRetailerFareInfo getRetailerFareInfo() {
        return retailerFareInfo;
    }

    /** 
     * Set the 'RetailerFareInfo' element value. Maps to *PQ#R
     * 
     * @param retailerFareInfo
     */
    public void setRetailerFareInfo(
            PriceQuoteDetailsRetailerFareInfo retailerFareInfo) {
        this.retailerFareInfo = retailerFareInfo;
    }

    /** 
     * Get the 'NetFareInfo' element value. Net fare data
     * 
     * @return value
     */
    public PriceQuoteDetailsNetFareInfo getNetFareInfo() {
        return netFareInfo;
    }

    /** 
     * Set the 'NetFareInfo' element value. Net fare data
     * 
     * @param netFareInfo
     */
    public void setNetFareInfo(PriceQuoteDetailsNetFareInfo netFareInfo) {
        this.netFareInfo = netFareInfo;
    }

    /** 
     * Get the 'NetRemitInfo' element value. Global Net remit
     * 
     * @return value
     */
    public PriceQuoteDetailsNetRemitInfo getNetRemitInfo() {
        return netRemitInfo;
    }

    /** 
     * Set the 'NetRemitInfo' element value. Global Net remit
     * 
     * @param netRemitInfo
     */
    public void setNetRemitInfo(PriceQuoteDetailsNetRemitInfo netRemitInfo) {
        this.netRemitInfo = netRemitInfo;
    }

    /** 
     * Get the 'NewSellingFareinfo' element value. New Selling Fare - applicable only for exchanages
     * 
     * @return value
     */
    public PriceQuoteDetailsNewSellingFareInfo getNewSellingFareinfo() {
        return newSellingFareinfo;
    }

    /** 
     * Set the 'NewSellingFareinfo' element value. New Selling Fare - applicable only for exchanages
     * 
     * @param newSellingFareinfo
     */
    public void setNewSellingFareinfo(
            PriceQuoteDetailsNewSellingFareInfo newSellingFareinfo) {
        this.newSellingFareinfo = newSellingFareinfo;
    }
}
