
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.AgentInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="HomeLocation"/>
 *     &lt;xs:element type="xs:string" name="WorkLocation" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="sine"/>
 *   &lt;xs:attribute type="xs:string" name="duty"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsAgentInfo implements Serializable
{
    private String homeLocation;
    private String workLocation;
    private String sine;
    private String duty;

    /** 
     * Get the 'HomeLocation' element value. Agent home city code
    					Ref: DM0Z_65_CHOM
    					Ref: DM0Z_E0_CHOM for history	
     * 
     * @return value
     */
    public String getHomeLocation() {
        return homeLocation;
    }

    /** 
     * Set the 'HomeLocation' element value. Agent home city code
    					Ref: DM0Z_65_CHOM
    					Ref: DM0Z_E0_CHOM for history	
     * 
     * @param homeLocation
     */
    public void setHomeLocation(String homeLocation) {
        this.homeLocation = homeLocation;
    }

    /** 
     * Get the 'WorkLocation' element value. Pseudo City Code
    					Ref: DM0Z_65_CCTY
    					Ref: DM0Z_E0_CCTY for history
     * 
     * @return value
     */
    public String getWorkLocation() {
        return workLocation;
    }

    /** 
     * Set the 'WorkLocation' element value. Pseudo City Code
    					Ref: DM0Z_65_CCTY
    					Ref: DM0Z_E0_CCTY for history
     * 
     * @param workLocation
     */
    public void setWorkLocation(String workLocation) {
        this.workLocation = workLocation;
    }

    /** 
     * Get the 'sine' attribute value. Agent sine-in code
    				Ref: DM0Z_65_CSIN
    				Ref: DM0Z_E0_CSIN for history                
     * 
     * @return value
     */
    public String getSine() {
        return sine;
    }

    /** 
     * Set the 'sine' attribute value. Agent sine-in code
    				Ref: DM0Z_65_CSIN
    				Ref: DM0Z_E0_CSIN for history                
     * 
     * @param sine
     */
    public void setSine(String sine) {
        this.sine = sine;
    }

    /** 
     * Get the 'duty' attribute value. Agent duty code.
    				Ref: DM0Z_65_CDTY
    				Ref: DM0Z_E0_CDTY for history
     * 
     * @return value
     */
    public String getDuty() {
        return duty;
    }

    /** 
     * Set the 'duty' attribute value. Agent duty code.
    				Ref: DM0Z_65_CDTY
    				Ref: DM0Z_E0_CDTY for history
     * 
     * @param duty
     */
    public void setDuty(String duty) {
        this.duty = duty;
    }
}
