
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.ExchangeDocInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.PassengerName" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="Base" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="Equivalent" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="Total" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NewSellingFareInfo" name="SellingFareinfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="nonFlightDoc"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:int" name="conjunctive"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsExchangeDocInfo implements Serializable
{
    private PriceQuoteDetailsPassengerName passengerName;
    private AmountPattern base;
    private AmountPattern equivalent;
    private Amount totalTax;
    private AmountPattern total;
    private PriceQuoteDetailsNewSellingFareInfo sellingFareinfo;
    private Boolean nonFlightDoc;
    private String number;
    private Integer conjunctive;

    /** 
     * Get the 'PassengerName' element value. Passenger Name
    Ref: DM0Z_68_VNAM
     * 
     * @return value
     */
    public PriceQuoteDetailsPassengerName getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. Passenger Name
    Ref: DM0Z_68_VNAM
     * 
     * @param passengerName
     */
    public void setPassengerName(PriceQuoteDetailsPassengerName passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'Base' element value. Exchange Document Base Amount
    Ref: DM0Z_36_BFAR

     * 
     * @return value
     */
    public AmountPattern getBase() {
        return base;
    }

    /** 
     * Set the 'Base' element value. Exchange Document Base Amount
    Ref: DM0Z_36_BFAR

     * 
     * @param base
     */
    public void setBase(AmountPattern base) {
        this.base = base;
    }

    /** 
     * Get the 'Equivalent' element value. Exchange Document Equivalent Amount
    Ref: DM0Z_36_EFAR
     * 
     * @return value
     */
    public AmountPattern getEquivalent() {
        return equivalent;
    }

    /** 
     * Set the 'Equivalent' element value. Exchange Document Equivalent Amount
    Ref: DM0Z_36_EFAR
     * 
     * @param equivalent
     */
    public void setEquivalent(AmountPattern equivalent) {
        this.equivalent = equivalent;
    }

    /** 
     * Get the 'TotalTax' element value. Exchange Document Total Tax Amount
    Ref: DM0Z_36_TTXA
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Exchange Document Total Tax Amount
    Ref: DM0Z_36_TTXA
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'Total' element value. Exchange Document Total  Amount
    Ref: DM0Z_36_TFAR
     * 
     * @return value
     */
    public AmountPattern getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Exchange Document Total  Amount
    Ref: DM0Z_36_TFAR
     * 
     * @param total
     */
    public void setTotal(AmountPattern total) {
        this.total = total;
    }

    /** 
     * Get the 'SellingFareinfo' element value. Selling Fare
     * 
     * @return value
     */
    public PriceQuoteDetailsNewSellingFareInfo getSellingFareinfo() {
        return sellingFareinfo;
    }

    /** 
     * Set the 'SellingFareinfo' element value. Selling Fare
     * 
     * @param sellingFareinfo
     */
    public void setSellingFareinfo(
            PriceQuoteDetailsNewSellingFareInfo sellingFareinfo) {
        this.sellingFareinfo = sellingFareinfo;
    }

    /** 
     * Get the 'nonFlightDoc' attribute value. True: for Non-Flight Doc, False: for Flight Doc;
    				default ie Flight Doc
    				Ref: DM0Z_38_DOCI 
     * 
     * @return value
     */
    public Boolean getNonFlightDoc() {
        return nonFlightDoc;
    }

    /** 
     * Set the 'nonFlightDoc' attribute value. True: for Non-Flight Doc, False: for Flight Doc;
    				default ie Flight Doc
    				Ref: DM0Z_38_DOCI 
     * 
     * @param nonFlightDoc
     */
    public void setNonFlightDoc(Boolean nonFlightDoc) {
        this.nonFlightDoc = nonFlightDoc;
    }

    /** 
     * Get the 'number' attribute value.  Document Number
    				Ref: DM0Z_38_DOCN 
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value.  Document Number
    				Ref: DM0Z_38_DOCN 
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'conjunctive' attribute value. Conjunctive range
    				Ref: DM0Z_38_CONJ 
     * 
     * @return value
     */
    public Integer getConjunctive() {
        return conjunctive;
    }

    /** 
     * Set the 'conjunctive' attribute value. Conjunctive range
    				Ref: DM0Z_38_CONJ 
     * 
     * @param conjunctive
     */
    public void setConjunctive(Integer conjunctive) {
        this.conjunctive = conjunctive;
    }
}
