
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.FareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Fare.Indicators" name="FareIndicators" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount.Pattern" name="TotalFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareCalculationType" name="FareCalculation" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyConversion" name="CurrencyConversion" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.CommissionDetails" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.HandlingFee" name="HandlingFee" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Fare.OptionalServiceInfo" name="OptionalServiceInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareComponent" name="FareComponent" minOccurs="0" maxOccurs="30"/>
 *     &lt;xs:element type="xs:string" name="WaiverInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:string" name="source"/>
 *   &lt;xs:attribute type="xs:string" name="multiEquivCurrency1"/>
 *   &lt;xs:attribute type="xs:string" name="multiEquivCurrency2"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsFareInfo implements Serializable
{
    private FareIndicators fareIndicators;
    private AmountPattern baseFare;
    private AmountPattern equivalentFare;
    private Amount totalTax;
    private AmountPattern totalFare;
    private FareTaxInfo taxInfo;
    private FareCalculationType fareCalculation;
    private CurrencyConversion currencyConversion;
    private FareCommissionDetails commission;
    private List<FareHandlingFee> handlingFeeList = new ArrayList<FareHandlingFee>();
    private List<FareOptionalServiceInfo> optionalServiceInfoList = new ArrayList<FareOptionalServiceInfo>();
    private List<PriceQuoteDetailsFareComponent> fareComponentList = new ArrayList<PriceQuoteDetailsFareComponent>();
    private String waiverInfo;
    private String type;
    private String source;
    private String multiEquivCurrency1;
    private String multiEquivCurrency2;

    /** 
     * Get the 'FareIndicators' element value. Fare level Indicators
     * 
     * @return value
     */
    public FareIndicators getFareIndicators() {
        return fareIndicators;
    }

    /** 
     * Set the 'FareIndicators' element value. Fare level Indicators
     * 
     * @param fareIndicators
     */
    public void setFareIndicators(FareIndicators fareIndicators) {
        this.fareIndicators = fareIndicators;
    }

    /** 
     * Get the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR		       DM0Z_CA_BFAR
    				
     * 
     * @return value
     */
    public AmountPattern getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR		       DM0Z_CA_BFAR
    				
     * 
     * @param baseFare
     */
    public void setBaseFare(AmountPattern baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
    					DM0Z_CA_EFAR
     * 
     * @return value
     */
    public AmountPattern getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
    					DM0Z_CA_EFAR
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(AmountPattern equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC
    					DM0Z_CA_TTAC	
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC
    					DM0Z_CA_TTAC	
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR
    					DM0Z_CA_TFAR		
     * 
     * @return value
     */
    public AmountPattern getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR
    					DM0Z_CA_TFAR		
     * 
     * @param totalFare
     */
    public void setTotalFare(AmountPattern totalFare) {
        this.totalFare = totalFare;
    }

    /** 
     * Get the 'TaxInfo' element value.
     * 
     * @return value
     */
    public FareTaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value.
     * 
     * @param taxInfo
     */
    public void setTaxInfo(FareTaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the 'FareCalculation' element value. FareCalc line free Text
    					Ref: DM0Z_A5_DATA
     * 
     * @return value
     */
    public FareCalculationType getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' element value. FareCalc line free Text
    					Ref: DM0Z_A5_DATA
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(FareCalculationType fareCalculation) {
        this.fareCalculation = fareCalculation;
    }

    /** 
     * Get the 'CurrencyConversion' element value.
     * 
     * @return value
     */
    public CurrencyConversion getCurrencyConversion() {
        return currencyConversion;
    }

    /** 
     * Set the 'CurrencyConversion' element value.
     * 
     * @param currencyConversion
     */
    public void setCurrencyConversion(CurrencyConversion currencyConversion) {
        this.currencyConversion = currencyConversion;
    }

    /** 
     * Get the 'Commission' element value. Commission at Farelevel
     * 
     * @return value
     */
    public FareCommissionDetails getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Commission at Farelevel
     * 
     * @param commission
     */
    public void setCommission(FareCommissionDetails commission) {
        this.commission = commission;
    }

    /** 
     * Get the list of 'HandlingFee' element items.
     * 
     * @return list
     */
    public List<FareHandlingFee> getHandlingFeeList() {
        return handlingFeeList;
    }

    /** 
     * Set the list of 'HandlingFee' element items.
     * 
     * @param list
     */
    public void setHandlingFeeList(List<FareHandlingFee> list) {
        handlingFeeList = list;
    }

    /** 
     * Get the list of 'OptionalServiceInfo' element items. Optional services bundled with the fare
    					Ref: DM0Z_E7_...
     * 
     * @return list
     */
    public List<FareOptionalServiceInfo> getOptionalServiceInfoList() {
        return optionalServiceInfoList;
    }

    /** 
     * Set the list of 'OptionalServiceInfo' element items. Optional services bundled with the fare
    					Ref: DM0Z_E7_...
     * 
     * @param list
     */
    public void setOptionalServiceInfoList(List<FareOptionalServiceInfo> list) {
        optionalServiceInfoList = list;
    }

    /** 
     * Get the list of 'FareComponent' element items.
     * 
     * @return list
     */
    public List<PriceQuoteDetailsFareComponent> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items.
     * 
     * @param list
     */
    public void setFareComponentList(List<PriceQuoteDetailsFareComponent> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'WaiverInfo' element value. ref:DM0Z_62_DATA

    					Waiver details applicable as returned from pricing
     * 
     * @return value
     */
    public String getWaiverInfo() {
        return waiverInfo;
    }

    /** 
     * Set the 'WaiverInfo' element value. ref:DM0Z_62_DATA

    					Waiver details applicable as returned from pricing
     * 
     * @param waiverInfo
     */
    public void setWaiverInfo(String waiverInfo) {
        this.waiverInfo = waiverInfo;
    }

    /** 
     * Get the 'type' attribute value. Type associated to the primary selling fare.

    				Possible Values:
    				ASL - Adjusted Selling Fare
    				MSL - Manual Adjusted Selling Fare

    				Ref: DM0Z_85_FTY #DM0Z_85_NOR

    				DM0Z_CA_FTYP
    				#DM0Z_CA_ASL #DM0Z_CA_MSL
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Type associated to the primary selling fare.

    				Possible Values:
    				ASL - Adjusted Selling Fare
    				MSL - Manual Adjusted Selling Fare

    				Ref: DM0Z_85_FTY #DM0Z_85_NOR

    				DM0Z_CA_FTYP
    				#DM0Z_CA_ASL #DM0Z_CA_MSL
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'source' attribute value. Fare source/vendor
    				Ref: DM0Z_85_FAR_SRCE
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'source' attribute value. Fare source/vendor
    				Ref: DM0Z_85_FAR_SRCE
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'multiEquivCurrency1' attribute value. Multi equivalent currency 1
    REF: DM0Z_85_BSCU 
     * 
     * @return value
     */
    public String getMultiEquivCurrency1() {
        return multiEquivCurrency1;
    }

    /** 
     * Set the 'multiEquivCurrency1' attribute value. Multi equivalent currency 1
    REF: DM0Z_85_BSCU 
     * 
     * @param multiEquivCurrency1
     */
    public void setMultiEquivCurrency1(String multiEquivCurrency1) {
        this.multiEquivCurrency1 = multiEquivCurrency1;
    }

    /** 
     * Get the 'multiEquivCurrency2' attribute value. Multi equivalent currency 2
    REF: DM0Z_85_BSCU
     * 
     * @return value
     */
    public String getMultiEquivCurrency2() {
        return multiEquivCurrency2;
    }

    /** 
     * Set the 'multiEquivCurrency2' attribute value. Multi equivalent currency 2
    REF: DM0Z_85_BSCU
     * 
     * @param multiEquivCurrency2
     */
    public void setMultiEquivCurrency2(String multiEquivCurrency2) {
        this.multiEquivCurrency2 = multiEquivCurrency2;
    }
}
