
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.NetFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareCalculationType" name="FareCalculation" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.Commission" name="Commission" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="MarkUp" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="tourTicket"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsNetFareInfo implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;
    private FareTaxInfo taxInfo;
    private FareCalculationType fareCalculation;
    private FareCommission commission;
    private Amount markUp;
    private Boolean tourTicket;

    /** 
     * Get the 'BaseFare' element value. Base amount for NetFare. Ref: DM0Z_86_BFAR 	
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base amount for NetFare. Ref: DM0Z_86_BFAR 	
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent amount for NetFare.
    					Ref: DM0Z_86_EFAR 
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent amount for NetFare.
    					Ref: DM0Z_86_EFAR 
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Total tax amount for NetFare.
    					Ref: DM0Z_86_TTAC 
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Total tax amount for NetFare.
    					Ref: DM0Z_86_TTAC 
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total amount for NetFare. Ref: DM0Z_86_TFAR 
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total amount for NetFare. Ref: DM0Z_86_TFAR 
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }

    /** 
     * Get the 'TaxInfo' element value. This contains taxes that exist in the tax boxes 1, 2, 3 for NetFare.
    					Ref: DM0Z_86_TAXn

    					Tax Breakdown
    					Ref: DM0Z_91_ITEM
     * 
     * @return value
     */
    public FareTaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value. This contains taxes that exist in the tax boxes 1, 2, 3 for NetFare.
    					Ref: DM0Z_86_TAXn

    					Tax Breakdown
    					Ref: DM0Z_91_ITEM
     * 
     * @param taxInfo
     */
    public void setTaxInfo(FareTaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the 'FareCalculation' element value. Fare calculation information related to NetFare Ref: DM0Z_A6_DATA
     * 
     * @return value
     */
    public FareCalculationType getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' element value. Fare calculation information related to NetFare Ref: DM0Z_A6_DATA
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(FareCalculationType fareCalculation) {
        this.fareCalculation = fareCalculation;
    }

    /** 
     * Get the 'Commission' element value. Holds commission associated to NetFare

    				
     * 
     * @return value
     */
    public FareCommission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Holds commission associated to NetFare

    				
     * 
     * @param commission
     */
    public void setCommission(FareCommission commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'MarkUp' element value. Difference between selling fare and net fare

    					Ref: DM0Z_C9_MKU_AMNT
     * 
     * @return value
     */
    public Amount getMarkUp() {
        return markUp;
    }

    /** 
     * Set the 'MarkUp' element value. Difference between selling fare and net fare

    					Ref: DM0Z_C9_MKU_AMNT
     * 
     * @param markUp
     */
    public void setMarkUp(Amount markUp) {
        this.markUp = markUp;
    }

    /** 
     * Get the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

    				DM0Z_85_BC35
    				#DM0Z_85_ITBT
     * 
     * @return value
     */
    public Boolean getTourTicket() {
        return tourTicket;
    }

    /** 
     * Set the 'tourTicket' attribute value. Set to true if net fare is for IT/BT

    				DM0Z_85_BC35
    				#DM0Z_85_ITBT
     * 
     * @param tourTicket
     */
    public void setTourTicket(Boolean tourTicket) {
        this.tourTicket = tourTicket;
    }
}
