
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.PublishedFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="EquivalentFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalTax" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="TotalFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.TaxInfo" name="TaxInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareCalculationType" name="FareCalculation" minOccurs="0"/>
 *     &lt;xs:element type="ns:Fare.CommissionDetails" name="Commission" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsPublishedFareInfo implements Serializable
{
    private Amount baseFare;
    private Amount equivalentFare;
    private Amount totalTax;
    private Amount totalFare;
    private FareTaxInfo taxInfo;
    private FareCalculationType fareCalculation;
    private FareCommissionDetails commission;

    /** 
     * Get the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR		
     * 
     * @return value
     */
    public Amount getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare per PQ type
    					Ref: DM0Z_85_BFAR		
     * 
     * @param baseFare
     */
    public void setBaseFare(Amount baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
     * 
     * @return value
     */
    public Amount getEquivalentFare() {
        return equivalentFare;
    }

    /** 
     * Set the 'EquivalentFare' element value. Equivalent Fare per PQ type
    					Ref: DM0Z_85_EFAR
     * 
     * @param equivalentFare
     */
    public void setEquivalentFare(Amount equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    /** 
     * Get the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC		
     * 
     * @return value
     */
    public Amount getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Tax Total per PQ type
    					Ref: DM0Z_85_TTAC		
     * 
     * @param totalTax
     */
    public void setTotalTax(Amount totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR			
     * 
     * @return value
     */
    public Amount getTotalFare() {
        return totalFare;
    }

    /** 
     * Set the 'TotalFare' element value. Total fare inclusive of taxes per PQ type
    					Ref: DM0Z_85_TFAR			
     * 
     * @param totalFare
     */
    public void setTotalFare(Amount totalFare) {
        this.totalFare = totalFare;
    }

    /** 
     * Get the 'TaxInfo' element value. Includes combinedTax and Tax breakdown.
     * 
     * @return value
     */
    public FareTaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value. Includes combinedTax and Tax breakdown.
     * 
     * @param taxInfo
     */
    public void setTaxInfo(FareTaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the 'FareCalculation' element value. FareCalc line free Text

    					Ref: DM0Z_A5_DATA
    				
     * 
     * @return value
     */
    public FareCalculationType getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' element value. FareCalc line free Text

    					Ref: DM0Z_A5_DATA
    				
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(FareCalculationType fareCalculation) {
        this.fareCalculation = fareCalculation;
    }

    /** 
     * Get the 'Commission' element value. Holds commission associated to published fare

    				
     * 
     * @return value
     */
    public FareCommissionDetails getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Holds commission associated to published fare

    				
     * 
     * @param commission
     */
    public void setCommission(FareCommissionDetails commission) {
        this.commission = commission;
    }
}
