
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.SegmentInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Segment.FlightData" name="Flight" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="NotValidBefore" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="NotValidAfter" minOccurs="0"/>
 *     &lt;xs:element type="ns:Segment.BaggageInfo" name="Baggage" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="FareComponentNumber" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.BrandedFare" name="BrandedFare" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="number"/>
 *   &lt;xs:attribute type="xs:string" name="type"/>
 *   &lt;xs:attribute type="xs:string" name="segmentStatus"/>
 *   &lt;xs:attribute type="xs:string" name="flown"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="segNumber"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="segID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsSegmentInfo implements Serializable
{
    private SegmentFlightData flight;
    private String fareBasis;
    private Date notValidBefore;
    private Date notValidAfter;
    private SegmentBaggageInfo baggage;
    private BigInteger fareComponentNumber;
    private PriceQuoteDetailsBrandedFare brandedFare;
    private BigInteger number;
    private String type;
    private String segmentStatus;
    private String flown;
    private String segNumber;
    private String segID;

    /** 
     * Get the 'Flight' element value. FlightInfo
     * 
     * @return value
     */
    public SegmentFlightData getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. FlightInfo
     * 
     * @param flight
     */
    public void setFlight(SegmentFlightData flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'FareBasis' element value. Ref: DM0Z_70_FBCD
     * 
     * @return value
     */
    public String getFareBasis() {
        return fareBasis;
    }

    /** 
     * Set the 'FareBasis' element value. Ref: DM0Z_70_FBCD
     * 
     * @param fareBasis
     */
    public void setFareBasis(String fareBasis) {
        this.fareBasis = fareBasis;
    }

    /** 
     * Get the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
    					Ref: DM0Z_70_NVBB
     * 
     * @return value
     */
    public Date getNotValidBefore() {
        return notValidBefore;
    }

    /** 
     * Set the 'NotValidBefore' element value. Not Valid Before Date - determine the validity of the ticket
    					Ref: DM0Z_70_NVBB
     * 
     * @param notValidBefore
     */
    public void setNotValidBefore(Date notValidBefore) {
        this.notValidBefore = notValidBefore;
    }

    /** 
     * Get the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
    					Ref: DM0Z_70_NVAB
     * 
     * @return value
     */
    public Date getNotValidAfter() {
        return notValidAfter;
    }

    /** 
     * Set the 'NotValidAfter' element value. Not Valid After Date - determine the validity of the ticket
    					Ref: DM0Z_70_NVAB
     * 
     * @param notValidAfter
     */
    public void setNotValidAfter(Date notValidAfter) {
        this.notValidAfter = notValidAfter;
    }

    /** 
     * Get the 'Baggage' element value. Baggage information
     * 
     * @return value
     */
    public SegmentBaggageInfo getBaggage() {
        return baggage;
    }

    /** 
     * Set the 'Baggage' element value. Baggage information
     * 
     * @param baggage
     */
    public void setBaggage(SegmentBaggageInfo baggage) {
        this.baggage = baggage;
    }

    /** 
     * Get the 'FareComponentNumber' element value. Display number of fare component stored in PQ

    					Ref: -  DM0Z_75_FCNR
     * 
     * @return value
     */
    public BigInteger getFareComponentNumber() {
        return fareComponentNumber;
    }

    /** 
     * Set the 'FareComponentNumber' element value. Display number of fare component stored in PQ

    					Ref: -  DM0Z_75_FCNR
     * 
     * @param fareComponentNumber
     */
    public void setFareComponentNumber(BigInteger fareComponentNumber) {
        this.fareComponentNumber = fareComponentNumber;
    }

    /** 
     * Get the 'BrandedFare' element value. Display branded fare info stored in PQ

    					Ref: -  DM0Z_70_BRCD
     * 
     * @return value
     */
    public PriceQuoteDetailsBrandedFare getBrandedFare() {
        return brandedFare;
    }

    /** 
     * Set the 'BrandedFare' element value. Display branded fare info stored in PQ

    					Ref: -  DM0Z_70_BRCD
     * 
     * @param brandedFare
     */
    public void setBrandedFare(PriceQuoteDetailsBrandedFare brandedFare) {
        this.brandedFare = brandedFare;
    }

    /** 
     * Get the 'number' attribute value. Entitlement number in PQ.
    Ref: DM0Z_70_LNBR
    			
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. Entitlement number in PQ.
    Ref: DM0Z_70_LNBR
    			
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'type' attribute value. Possible values:
    				A = Arunk
    				O = Open 
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Possible values:
    				A = Arunk
    				O = Open 
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'segmentStatus' attribute value. Possbile values:
    				OK
    				HQ
    				Ref: DM0Z_70_STAT
     * 
     * @return value
     */
    public String getSegmentStatus() {
        return segmentStatus;
    }

    /** 
     * Set the 'segmentStatus' attribute value. Possbile values:
    				OK
    				HQ
    				Ref: DM0Z_70_STAT
     * 
     * @param segmentStatus
     */
    public void setSegmentStatus(String segmentStatus) {
        this.segmentStatus = segmentStatus;
    }

    /** 
     * Get the 'flown' attribute value. Flown segment
    Ref: DM0Z_70_FLID
     * 
     * @return value
     */
    public String getFlown() {
        return flown;
    }

    /** 
     * Set the 'flown' attribute value. Flown segment
    Ref: DM0Z_70_FLID
     * 
     * @param flown
     */
    public void setFlown(String flown) {
        this.flown = flown;
    }

    /** 
     * Get the 'segNumber' attribute value. PNR Segment number at time of PQ/PQR create 
    Ref: DM0Z_70_SEGN
     * 
     * @return value
     */
    public String getSegNumber() {
        return segNumber;
    }

    /** 
     * Set the 'segNumber' attribute value. PNR Segment number at time of PQ/PQR create 
    Ref: DM0Z_70_SEGN
     * 
     * @param segNumber
     */
    public void setSegNumber(String segNumber) {
        this.segNumber = segNumber;
    }

    /** 
     * Get the 'segID' attribute value. PNR segment ID
    Ref: DM0Z_70_SEGI
     * 
     * @return value
     */
    public String getSegID() {
        return segID;
    }

    /** 
     * Set the 'segID' attribute value. PNR segment ID
    Ref: DM0Z_70_SEGI
     * 
     * @param segID
     */
    public void setSegID(String segID) {
        this.segID = segID;
    }
}
