
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Details.TransactionInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:dateTime" name="CreateDateTime"/>
 *     &lt;xs:element type="xs:dateTime" name="UpdateDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LocalCreateDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LocalUpdateDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReissueMethod" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReissueResult" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="taxModified"/>
 *   &lt;xs:attribute type="xs:boolean" name="changeFeeModified"/>
 *   &lt;xs:attribute type="xs:boolean" name="bagModified"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteDetailsTransactionInfo implements Serializable
{
    private Date createDateTime;
    private Date updateDateTime;
    private Date lastDateToPurchase;
    private Date localCreateDateTime;
    private Date localUpdateDateTime;
    private Date expiryDateTime;
    private String inputEntry;
    private String reissueMethod;
    private String reissueResult;
    private Boolean taxModified;
    private Boolean changeFeeModified;
    private Boolean bagModified;

    /** 
     * Get the 'CreateDateTime' element value. System Date/time the PQ was created
    					Ref: DM0Z_65_CLDB and
    					DM0Z_65_CLTB
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' element value. System Date/time the PQ was created
    					Ref: DM0Z_65_CLDB and
    					DM0Z_65_CLTB
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' element value. System Date/time the PQ was updated.
    					Ref: DM0Z_65_ULDB and
    					DM0Z_65_ULTB
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' element value. System Date/time the PQ was updated.
    					Ref: DM0Z_65_ULDB and
    					DM0Z_65_ULTB
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
     * 
     * @return value
     */
    public Date getLastDateToPurchase() {
        return lastDateToPurchase;
    }

    /** 
     * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
     * 
     * @param lastDateToPurchase
     */
    public void setLastDateToPurchase(Date lastDateToPurchase) {
        this.lastDateToPurchase = lastDateToPurchase;
    }

    /** 
     * Get the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
    					Ref: SR06PQ-20_CLDB/CTIM
     * 
     * @return value
     */
    public Date getLocalCreateDateTime() {
        return localCreateDateTime;
    }

    /** 
     * Set the 'LocalCreateDateTime' element value. Local Create Date/time the PQ was updated.
    					Ref: SR06PQ-20_CLDB/CTIM
     * 
     * @param localCreateDateTime
     */
    public void setLocalCreateDateTime(Date localCreateDateTime) {
        this.localCreateDateTime = localCreateDateTime;
    }

    /** 
     * Get the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
    					Ref: SR06PQ-20_ULDB/ULTB
     * 
     * @return value
     */
    public Date getLocalUpdateDateTime() {
        return localUpdateDateTime;
    }

    /** 
     * Set the 'LocalUpdateDateTime' element value. Local Update Date/time the PQ was updated.
    					Ref: SR06PQ-20_ULDB/ULTB
     * 
     * @param localUpdateDateTime
     */
    public void setLocalUpdateDateTime(Date localUpdateDateTime) {
        this.localUpdateDateTime = localUpdateDateTime;
    }

    /** 
     * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
     * 
     * @return value
     */
    public Date getExpiryDateTime() {
        return expiryDateTime;
    }

    /** 
     * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
     * 
     * @param expiryDateTime
     */
    public void setExpiryDateTime(Date expiryDateTime) {
        this.expiryDateTime = expiryDateTime;
    }

    /** 
     * Get the 'InputEntry' element value. Entry made to update the price quote.
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_PRI
    					#DM0Z_60_MAN
     * 
     * @return value
     */
    public String getInputEntry() {
        return inputEntry;
    }

    /** 
     * Set the 'InputEntry' element value. Entry made to update the price quote.
    					Ref: DM0Z_60_TYPE
    					#DM0Z_60_PRI
    					#DM0Z_60_MAN
     * 
     * @param inputEntry
     */
    public void setInputEntry(String inputEntry) {
        this.inputEntry = inputEntry;
    }

    /** 
     * Get the 'ReissueMethod' element value. possible values -
    					- EXCH
    					- RFND
    					- AUTOREDIRECT
    					- AUTOEXCH
    					- AUTORFND
     * 
     * @return value
     */
    public String getReissueMethod() {
        return reissueMethod;
    }

    /** 
     * Set the 'ReissueMethod' element value. possible values -
    					- EXCH
    					- RFND
    					- AUTOREDIRECT
    					- AUTOEXCH
    					- AUTORFND
     * 
     * @param reissueMethod
     */
    public void setReissueMethod(String reissueMethod) {
        this.reissueMethod = reissueMethod;
    }

    /** 
     * Get the 'ReissueResult' element value. Result of the Reissue transaction
    					Ex: EVEN, FEES or A/C, FEES
     * 
     * @return value
     */
    public String getReissueResult() {
        return reissueResult;
    }

    /** 
     * Set the 'ReissueResult' element value. Result of the Reissue transaction
    					Ex: EVEN, FEES or A/C, FEES
     * 
     * @param reissueResult
     */
    public void setReissueResult(String reissueResult) {
        this.reissueResult = reissueResult;
    }

    /** 
     * Get the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
    				Tax modified - applicable only for CAT31
     * 
     * @return value
     */
    public Boolean getTaxModified() {
        return taxModified;
    }

    /** 
     * Set the 'taxModified' attribute value. Ref: #DM0Z_85_TMOD
    				Tax modified - applicable only for CAT31
     * 
     * @param taxModified
     */
    public void setTaxModified(Boolean taxModified) {
        this.taxModified = taxModified;
    }

    /** 
     * Get the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
    				Change Fee modified - applicable only for CAT31
     * 
     * @return value
     */
    public Boolean getChangeFeeModified() {
        return changeFeeModified;
    }

    /** 
     * Set the 'changeFeeModified' attribute value. Ref: #DM0Z_85_CMOD
    				Change Fee modified - applicable only for CAT31
     * 
     * @param changeFeeModified
     */
    public void setChangeFeeModified(Boolean changeFeeModified) {
        this.changeFeeModified = changeFeeModified;
    }

    /** 
     * Get the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
     * 
     * @return value
     */
    public Boolean getBagModified() {
        return bagModified;
    }

    /** 
     * Set the 'bagModified' attribute value. Ref: #DM0Z_40_BOVR
     * 
     * @param bagModified
     */
    public void setBagModified(Boolean bagModified) {
        this.bagModified = bagModified;
    }
}
