
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Item.Fee.CommonAssociation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount"/>
 *     &lt;xs:element type="xs:string" name="Waiver" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteItemFeeCommonAssociation implements Serializable
{
    private Amount amount;
    private String waiver;
    private String type;
    private String code;
    private BigInteger itemId;

    /** 
     * Get the 'Amount' element value. Fee Amount
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Fee Amount
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
    					override functionality is used, the transaction will be logged to the overrride report.
    				
     * 
     * @return value
     */
    public String getWaiver() {
        return waiver;
    }

    /** 
     * Set the 'Waiver' element value. A reason code used to override the fee for the purpose of not collecting any payment for that fee. When
    					override functionality is used, the transaction will be logged to the overrride report.
    				
     * 
     * @param waiver
     */
    public void setWaiver(String waiver) {
        this.waiver = waiver;
    }

    /** 
     * Get the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
     * 
     * @return value
     */
    public BigInteger getItemId() {
        return itemId;
    }

    /** 
     * Set the 'itemId' attribute value. Fee item identifier that uniquely identifies this fee association to the name
     * 
     * @param itemId
     */
    public void setItemId(BigInteger itemId) {
        this.itemId = itemId;
    }
}
