
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Item.OBFee.Details">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:Amount" name="Amount"/>
 *       &lt;xs:element type="ns:Amount" name="MaxAmount"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:Amount" name="Total" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BankIdentificationNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="noChargeIndicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteItemOBFeeDetails implements Serializable
{
    private int choiceSelect = -1;
    private static final int AMOUNT_CHOICE = 0;
    private static final int MAX_AMOUNT_CHOICE = 1;
    private Amount amount;
    private Amount maxAmount;
    private Amount total;
    private String description;
    private String bankIdentificationNumber;
    private String type;
    private String code;
    private String noChargeIndicator;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Amount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmount() {
        return choiceSelect == AMOUNT_CHOICE;
    }

    /** 
     * Get the 'Amount' element value. OB Fee Amount
    						Ref: DM0Z_E1_OB_FAMT
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. OB Fee Amount
    						Ref: DM0Z_E1_OB_FAMT
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        setChoiceSelect(AMOUNT_CHOICE);
        this.amount = amount;
    }

    /** 
     * Check if MaxAmount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMaxAmount() {
        return choiceSelect == MAX_AMOUNT_CHOICE;
    }

    /** 
     * Get the 'MaxAmount' element value. Max Fee Amount
    						Ref: DM0Z_E1_OB_MCHA
     * 
     * @return value
     */
    public Amount getMaxAmount() {
        return maxAmount;
    }

    /** 
     * Set the 'MaxAmount' element value. Max Fee Amount
    						Ref: DM0Z_E1_OB_MCHA
     * 
     * @param maxAmount
     */
    public void setMaxAmount(Amount maxAmount) {
        setChoiceSelect(MAX_AMOUNT_CHOICE);
        this.maxAmount = maxAmount;
    }

    /** 
     * Get the 'Total' element value. Total Fee Amount
    					Ref:
    					DM0ZAA_E1_TAMT
     * 
     * @return value
     */
    public Amount getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Total Fee Amount
    					Ref:
    					DM0ZAA_E1_TAMT
     * 
     * @param total
     */
    public void setTotal(Amount total) {
        this.total = total;
    }

    /** 
     * Get the 'Description' element value. Description of a fee item

    					Ref: DM0Z_E1_OB_DESP
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description of a fee item

    					Ref: DM0Z_E1_OB_DESP
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'BankIdentificationNumber' element value. 
    					Ref: DM0Z_E1_OB_BIN
     * 
     * @return value
     */
    public String getBankIdentificationNumber() {
        return bankIdentificationNumber;
    }

    /** 
     * Set the 'BankIdentificationNumber' element value. 
    					Ref: DM0Z_E1_OB_BIN
     * 
     * @param bankIdentificationNumber
     */
    public void setBankIdentificationNumber(String bankIdentificationNumber) {
        this.bankIdentificationNumber = bankIdentificationNumber;
    }

    /** 
     * Get the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'noChargeIndicator' attribute value. Possible Values:
    				X
    				Y
    				0
    				Ref: DM0Z_E1_OB_NCHR
     * 
     * @return value
     */
    public String getNoChargeIndicator() {
        return noChargeIndicator;
    }

    /** 
     * Set the 'noChargeIndicator' attribute value. Possible Values:
    				X
    				Y
    				0
    				Ref: DM0Z_E1_OB_NCHR
     * 
     * @param noChargeIndicator
     */
    public void setNoChargeIndicator(String noChargeIndicator) {
        this.noChargeIndicator = noChargeIndicator;
    }
}
