
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Response.Summary">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Response.NameAssociation" name="NameAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Response.NoNameAssociation" name="NoNameAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Summary.SummaryByPassengerType" name="SummaryByPassengerType" minOccurs="0"/>
 *     &lt;xs:element name="PQFInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class PQFInfo -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteResponseSummary implements Serializable
{
    private List<PriceQuoteResponseNameAssociation> nameAssociationList = new ArrayList<PriceQuoteResponseNameAssociation>();
    private List<PriceQuoteResponseNoNameAssociation> noNameAssociationList = new ArrayList<PriceQuoteResponseNoNameAssociation>();
    private PriceQuoteSummarySummaryByPassengerType summaryByPassengerType;
    private PQFInfo PQFInfo1;

    /** 
     * Get the list of 'NameAssociation' element items. Defines association of a passenger to the Price Quote and the Price Quote items. This information is equivalent
    					to *PQS
    				
     * 
     * @return list
     */
    public List<PriceQuoteResponseNameAssociation> getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the list of 'NameAssociation' element items. Defines association of a passenger to the Price Quote and the Price Quote items. This information is equivalent
    					to *PQS
    				
     * 
     * @param list
     */
    public void setNameAssociationList(
            List<PriceQuoteResponseNameAssociation> list) {
        nameAssociationList = list;
    }

    /** 
     * Get the list of 'NoNameAssociation' element items. Defines Price Quotes that are not name associated in the summary (part of  equivalent *PQS)
    				
     * 
     * @return list
     */
    public List<PriceQuoteResponseNoNameAssociation> getNoNameAssociationList() {
        return noNameAssociationList;
    }

    /** 
     * Set the list of 'NoNameAssociation' element items. Defines Price Quotes that are not name associated in the summary (part of  equivalent *PQS)
    				
     * 
     * @param list
     */
    public void setNoNameAssociationList(
            List<PriceQuoteResponseNoNameAssociation> list) {
        noNameAssociationList = list;
    }

    /** 
     * Get the 'SummaryByPassengerType' element value. Price Quote Record :  This information is equivalent to *PQSB/*PQST
     * 
     * @return value
     */
    public PriceQuoteSummarySummaryByPassengerType getSummaryByPassengerType() {
        return summaryByPassengerType;
    }

    /** 
     * Set the 'SummaryByPassengerType' element value. Price Quote Record :  This information is equivalent to *PQSB/*PQST
     * 
     * @param summaryByPassengerType
     */
    public void setSummaryByPassengerType(
            PriceQuoteSummarySummaryByPassengerType summaryByPassengerType) {
        this.summaryByPassengerType = summaryByPassengerType;
    }

    /** 
     * Get the 'PQFInfo' element value.
     * 
     * @return value
     */
    public PQFInfo getPQFInfo1() {
        return PQFInfo1;
    }

    /** 
     * Set the 'PQFInfo' element value.
     * 
     * @param PQFInfo1
     */
    public void setPQFInfo1(PQFInfo PQFInfo1) {
        this.PQFInfo1 = PQFInfo1;
    }
    /** 
     * PQF information in PNR
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PQFInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PQFBP.TextType" name="BoardingPassInhibit" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="ChangeFee" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ChangeFee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PQFInfo implements Serializable
    {
        private List<PQFBPTextType> boardingPassInhibitList = new ArrayList<PQFBPTextType>();
        private List<ChangeFee> changeFeeList = new ArrayList<ChangeFee>();

        /** 
         * Get the list of 'BoardingPassInhibit' element items. PQFBP details
         * 
         * @return list
         */
        public List<PQFBPTextType> getBoardingPassInhibitList() {
            return boardingPassInhibitList;
        }

        /** 
         * Set the list of 'BoardingPassInhibit' element items. PQFBP details
         * 
         * @param list
         */
        public void setBoardingPassInhibitList(List<PQFBPTextType> list) {
            boardingPassInhibitList = list;
        }

        /** 
         * Get the list of 'ChangeFee' element items.
         * 
         * @return list
         */
        public List<ChangeFee> getChangeFeeList() {
            return changeFeeList;
        }

        /** 
         * Set the list of 'ChangeFee' element items.
         * 
         * @param list
         */
        public void setChangeFeeList(List<ChangeFee> list) {
            changeFeeList = list;
        }
        /** 
         * PQFCF details
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeFee" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Amount" name="Amount"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="nameNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="firstName"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="lastName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ChangeFee implements Serializable
        {
            private Amount amount;
            private String nameNumber;
            private String firstName;
            private String lastName;

            /** 
             * Get the 'Amount' element value.
             * 
             * @return value
             */
            public Amount getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value.
             * 
             * @param amount
             */
            public void setAmount(Amount amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @return value
             */
            public String getNameNumber() {
                return nameNumber;
            }

            /** 
             * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
             * 
             * @param nameNumber
             */
            public void setNameNumber(String nameNumber) {
                this.nameNumber = nameNumber;
            }

            /** 
             * Get the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
            		
             * 
             * @return value
             */
            public String getFirstName() {
                return firstName;
            }

            /** 
             * Set the 'firstName' attribute value. First Name Ref: SR06PQ_30_FST
            		
             * 
             * @param firstName
             */
            public void setFirstName(String firstName) {
                this.firstName = firstName;
            }

            /** 
             * Get the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
            		
             * 
             * @return value
             */
            public String getLastName() {
                return lastName;
            }

            /** 
             * Set the 'lastName' attribute value. Last Name Ref: SR06PQ_30_LST
            		
             * 
             * @param lastName
             */
            public void setLastName(String lastName) {
                this.lastName = lastName;
            }
        }
    }
}
