
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Search">
 *   &lt;xs:attribute type="xs:integer" name="number"/>
 *   &lt;xs:attribute type="xs:integer" name="endNumber"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteSearch implements Serializable
{
    private BigInteger number;
    private BigInteger endNumber;

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database

    				If not specified, it defaults to ALL PQs attached to the PNR
    			
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database

    				If not specified, it defaults to ALL PQs attached to the PNR
    			
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'endNumber' attribute value. PQ end number for range		
     * 
     * @return value
     */
    public BigInteger getEndNumber() {
        return endNumber;
    }

    /** 
     * Set the 'endNumber' attribute value. PQ end number for range		
     * 
     * @param endNumber
     */
    public void setEndNumber(BigInteger endNumber) {
        this.endNumber = endNumber;
    }
}
