
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.UpdateAssociation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Action.UpdateAssociation.Set" name="Set" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Action.UpdateAssociation.Remove" name="Remove" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteUpdateAssociation implements Serializable
{
    private PriceQuoteActionUpdateAssociationSet set;
    private PriceQuoteActionUpdateAssociationRemove remove;
    private String type;
    private BigInteger number;

    /** 
     * Get the 'Set' element value. This action allows to set new name association or update existing name association
     * 
     * @return value
     */
    public PriceQuoteActionUpdateAssociationSet getSet() {
        return set;
    }

    /** 
     * Set the 'Set' element value. This action allows to set new name association or update existing name association
     * 
     * @param set
     */
    public void setSet(PriceQuoteActionUpdateAssociationSet set) {
        this.set = set;
    }

    /** 
     * Get the 'Remove' element value. This action allows to remove existing name association
     * 
     * @return value
     */
    public PriceQuoteActionUpdateAssociationRemove getRemove() {
        return remove;
    }

    /** 
     * Set the 'Remove' element value. This action allows to remove existing name association
     * 
     * @param remove
     */
    public void setRemove(PriceQuoteActionUpdateAssociationRemove remove) {
        this.remove = remove;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }
}
