
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Residual.RefundableAmount">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="AdjustedAmount" minOccurs="0"/>
 *     &lt;xs:element type="ns:Residual.Tax" name="Taxes" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:Amount" name="AmountIssuedOnEMD" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResidualRefundableAmount implements Serializable
{
    private Amount adjustedAmount;
    private List<ResidualTax> taxeList = new ArrayList<ResidualTax>();
    private Amount amountIssuedOnEMD;

    /** 
     * Get the 'AdjustedAmount' element value. Residual amount refundable per rule - Adjusted when penalty is applicable
     * 
     * @return value
     */
    public Amount getAdjustedAmount() {
        return adjustedAmount;
    }

    /** 
     * Set the 'AdjustedAmount' element value. Residual amount refundable per rule - Adjusted when penalty is applicable
     * 
     * @param adjustedAmount
     */
    public void setAdjustedAmount(Amount adjustedAmount) {
        this.adjustedAmount = adjustedAmount;
    }

    /** 
     * Get the list of 'Taxes' element items.
     * 
     * @return list
     */
    public List<ResidualTax> getTaxeList() {
        return taxeList;
    }

    /** 
     * Set the list of 'Taxes' element items.
     * 
     * @param list
     */
    public void setTaxeList(List<ResidualTax> list) {
        taxeList = list;
    }

    /** 
     * Get the 'AmountIssuedOnEMD' element value. Residual amount issued as EMD
    Ref: #DM0Z_B9_RFBAL
    DM0Z_B9_RB_AMTC
     * 
     * @return value
     */
    public Amount getAmountIssuedOnEMD() {
        return amountIssuedOnEMD;
    }

    /** 
     * Set the 'AmountIssuedOnEMD' element value. Residual amount issued as EMD
    Ref: #DM0Z_B9_RFBAL
    DM0Z_B9_RB_AMTC
     * 
     * @param amountIssuedOnEMD
     */
    public void setAmountIssuedOnEMD(Amount amountIssuedOnEMD) {
        this.amountIssuedOnEMD = amountIssuedOnEMD;
    }
}
