
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchParameterChoice.CG">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PriceQuote.Search" name="PriceQuote" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TravelItinerary.Search" name="TravelItinerary"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class SearchParameterChoiceCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int PRICE_QUOTE_LIST_CHOICE = 0;
    private static final int TRAVEL_ITINERARY_CHOICE = 1;
    private List<PriceQuoteSearch> priceQuoteList = new ArrayList<PriceQuoteSearch>();
    private TravelItinerarySearch travelItinerary;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PriceQuoteList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceQuoteList() {
        return choiceSelect == PRICE_QUOTE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'PriceQuote' element items. Searched Price Quote information
     * 
     * @return list
     */
    public List<PriceQuoteSearch> getPriceQuoteList() {
        return priceQuoteList;
    }

    /** 
     * Set the list of 'PriceQuote' element items. Searched Price Quote information
     * 
     * @param list
     */
    public void setPriceQuoteList(List<PriceQuoteSearch> list) {
        setChoiceSelect(PRICE_QUOTE_LIST_CHOICE);
        priceQuoteList = list;
    }

    /** 
     * Check if TravelItinerary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelItinerary() {
        return choiceSelect == TRAVEL_ITINERARY_CHOICE;
    }

    /** 
     * Get the 'TravelItinerary' element value. Searched Price Quote information by TravelItinerary
     * 
     * @return value
     */
    public TravelItinerarySearch getTravelItinerary() {
        return travelItinerary;
    }

    /** 
     * Set the 'TravelItinerary' element value. Searched Price Quote information by TravelItinerary
     * 
     * @param travelItinerary
     */
    public void setTravelItinerary(TravelItinerarySearch travelItinerary) {
        setChoiceSelect(TRAVEL_ITINERARY_CHOICE);
        this.travelItinerary = travelItinerary;
    }
}
