
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePriceQuote.NameAssociation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Item.Fee.CommonAssociation" name="Fee" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="status"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdatePriceQuoteNameAssociation implements Serializable
{
    private List<PriceQuoteItemFeeCommonAssociation> feeList = new ArrayList<PriceQuoteItemFeeCommonAssociation>();
    private String type;
    private BigInteger number;
    private String status;

    /** 
     * Get the list of 'Fee' element items. Only 50 fee items can be stored per PQ
     * 
     * @return list
     */
    public List<PriceQuoteItemFeeCommonAssociation> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items. Only 50 fee items can be stored per PQ
     * 
     * @param list
     */
    public void setFeeList(List<PriceQuoteItemFeeCommonAssociation> list) {
        feeList = list;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'status' attribute value. PQ status

    				Possible values are:
    				A - Active
    				H - History
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
    			
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. PQ status

    				Possible values are:
    				A - Active
    				H - History
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
    			
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }
}
