
package com.sabre.ns.ticketing.pqs;

import com.sabre.ns.ticketing.ttl.HeaderBase;
import com.sabre.ns.ticketing.ttl.IdentifierPOS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePriceQuoteRQ">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:Header.Base" name="Header" minOccurs="0"/>
 *     &lt;xs:element type="ns1:Identifier.POS" name="POS"/>
 *     &lt;xs:element name="Transaction" minOccurs="0">
 *       &lt;!-- Reference to inner class Transaction -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PriceQuoteInfo.Update" name="PriceQuoteInfo" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PriceQuoteStdAttributes"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteStdAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class UpdatePriceQuoteRQ implements Serializable
{
    private HeaderBase header;
    private IdentifierPOS POS;
    private Transaction transaction;
    private List<PriceQuoteInfoUpdate> priceQuoteInfoList = new ArrayList<PriceQuoteInfoUpdate>();
    private List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public HeaderBase getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(HeaderBase header) {
        this.header = header;
    }

    /** 
     * Get the 'POS' element value. Point Of Sale and Agent information.
     * 
     * @return value
     */
    public IdentifierPOS getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point Of Sale and Agent information.
     * 
     * @param POS
     */
    public void setPOS(IdentifierPOS POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'Transaction' element value.
     * 
     * @return value
     */
    public Transaction getTransaction() {
        return transaction;
    }

    /** 
     * Set the 'Transaction' element value.
     * 
     * @param transaction
     */
    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    /** 
     * Get the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR

    					Ticketing System can update more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
    					and attempt to update Price Quotes in more than one PNR will result in error
    				
     * 
     * @return list
     */
    public List<PriceQuoteInfoUpdate> getPriceQuoteInfoList() {
        return priceQuoteInfoList;
    }

    /** 
     * Set the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR

    					Ticketing System can update more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
    					and attempt to update Price Quotes in more than one PNR will result in error
    				
     * 
     * @param list
     */
    public void setPriceQuoteInfoList(List<PriceQuoteInfoUpdate> list) {
        priceQuoteInfoList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items.
     * 
     * @return list
     */
    public List<Diagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items.
     * 
     * @param list
     */
    public void setDiagnosticList(List<Diagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transaction" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" name="stateful"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Transaction implements Serializable
    {
        private Boolean stateful;

        /** 
         * Get the 'stateful' attribute value.
         * 
         * @return value
         */
        public Boolean getStateful() {
            return stateful;
        }

        /** 
         * Set the 'stateful' attribute value.
         * 
         * @param stateful
         */
        public void setStateful(Boolean stateful) {
            this.stateful = stateful;
        }
    }
}
