
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePriceQuote.Response.NameAssociation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:UpdatePriceQuote.NameAssociation" name="PriceQuote" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="nameNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="nameId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdatePriceQuoteResponseNameAssociation implements Serializable
{
    private List<UpdatePriceQuoteNameAssociation> priceQuoteList = new ArrayList<UpdatePriceQuoteNameAssociation>();
    private String nameNumber;
    private BigInteger nameId;

    /** 
     * Get the list of 'PriceQuote' element items.
     * 
     * @return list
     */
    public List<UpdatePriceQuoteNameAssociation> getPriceQuoteList() {
        return priceQuoteList;
    }

    /** 
     * Set the list of 'PriceQuote' element items.
     * 
     * @param list
     */
    public void setPriceQuoteList(List<UpdatePriceQuoteNameAssociation> list) {
        priceQuoteList = list;
    }

    /** 
     * Get the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
    			
     * 
     * @return value
     */
    public String getNameNumber() {
        return nameNumber;
    }

    /** 
     * Set the 'nameNumber' attribute value. A sequence number of the customer name as it is stored in the reservation record.
    			
     * 
     * @param nameNumber
     */
    public void setNameNumber(String nameNumber) {
        this.nameNumber = nameNumber;
    }

    /** 
     * Get the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
    			
     * 
     * @return value
     */
    public BigInteger getNameId() {
        return nameId;
    }

    /** 
     * Set the 'nameId' attribute value. A unique number associated to the customer/traveler name in the reservation record (PNR)
    			
     * 
     * @param nameId
     */
    public void setNameId(BigInteger nameId) {
        this.nameId = nameId;
    }
}
