
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;
import java.util.Date;

/** 
 * Ticketing Standard Payload Header.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.Base">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Header.TrackingID" name="OrchestrationID" minOccurs="0"/>
 *     &lt;xs:element type="ns:SecurityTokenCG" name="Security" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DiagnosticData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="messageID"/>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderBase implements Serializable
{
    private HeaderTrackingID orchestrationID;
    private SecurityTokenCG security;
    private String diagnosticData;
    private String messageID;
    private Date timeStamp;

    /** 
     * Get the 'OrchestrationID' element value. The orchestration ID may be used to track a set of service invocations and the sequence in which they are invoked. 
     * 
     * @return value
     */
    public HeaderTrackingID getOrchestrationID() {
        return orchestrationID;
    }

    /** 
     * Set the 'OrchestrationID' element value. The orchestration ID may be used to track a set of service invocations and the sequence in which they are invoked. 
     * 
     * @param orchestrationID
     */
    public void setOrchestrationID(HeaderTrackingID orchestrationID) {
        this.orchestrationID = orchestrationID;
    }

    /** 
     * Get the 'Security' element value.
     * 
     * @return value
     */
    public SecurityTokenCG getSecurity() {
        return security;
    }

    /** 
     * Set the 'Security' element value.
     * 
     * @param security
     */
    public void setSecurity(SecurityTokenCG security) {
        this.security = security;
    }

    /** 
     * Get the 'DiagnosticData' element value. Additional free text data
     * 
     * @return value
     */
    public String getDiagnosticData() {
        return diagnosticData;
    }

    /** 
     * Set the 'DiagnosticData' element value. Additional free text data
     * 
     * @param diagnosticData
     */
    public void setDiagnosticData(String diagnosticData) {
        this.diagnosticData = diagnosticData;
    }

    /** 
     * Get the 'messageID' attribute value. The MessageId element is a globally unique identifier for each message [see RFC2822]. It is an unique message identifier that refers to a particular version of a particular message.  The uniqueness of the message identifier should be guaranteed by the host that generates it.  This message identifier is intended to be machine readable and not necessarily meaningful to humans.  A message identifier pertains to exactly one instantiation of a particular message; subsequent revisions to the message each receive new message identifiers.
     * 
     * @return value
     */
    public String getMessageID() {
        return messageID;
    }

    /** 
     * Set the 'messageID' attribute value. The MessageId element is a globally unique identifier for each message [see RFC2822]. It is an unique message identifier that refers to a particular version of a particular message.  The uniqueness of the message identifier should be guaranteed by the host that generates it.  This message identifier is intended to be machine readable and not necessarily meaningful to humans.  A message identifier pertains to exactly one instantiation of a particular message; subsequent revisions to the message each receive new message identifiers.
     * 
     * @param messageID
     */
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    /** 
     * Get the 'timeStamp' attribute value. Date and time when the result record was created.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value. Date and time when the result record was created.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
