
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Completion statuses codes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.CompletionCodes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="Incomplete"/>
 *     &lt;xs:enumeration value="NotProcessed"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum HeaderCompletionCodes implements Serializable {
    COMPLETE("Complete"), INCOMPLETE("Incomplete"), NOT_PROCESSED(
            "NotProcessed"), UNKNOWN("Unknown");
    private final String value;

    private HeaderCompletionCodes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static HeaderCompletionCodes convert(String value) {
        for (HeaderCompletionCodes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
