
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Error information type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.ProblemInformation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Header.Identifier.System" name="Source" minOccurs="0"/>
 *     &lt;xs:element type="ns:Header.Identifier.System" name="System"/>
 *     &lt;xs:element type="ns:Header.SystemSpecificResults" name="SystemSpecificResults" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Header.ErrorType" use="required" name="type"/>
 *   &lt;xs:attribute type="ns:Header.CompletionCodes" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderProblemInformation implements Serializable
{
    private HeaderIdentifierSystem source;
    private HeaderIdentifierSystem system;
    private List<HeaderSystemSpecificResults> systemSpecificResultList = new ArrayList<HeaderSystemSpecificResults>();
    private HeaderErrorType type;
    private HeaderCompletionCodes status;
    private Date timeStamp;

    /** 
     * Get the 'Source' element value. The system that the error reporting system deemed to be the cause of the problem. If omitted, the reporting system is also the source of the problem. For application errors, the element may identify a system the application is dependent upon that failed to respond. For validation errors this may identify the service consumer.
     * 
     * @return value
     */
    public HeaderIdentifierSystem getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. The system that the error reporting system deemed to be the cause of the problem. If omitted, the reporting system is also the source of the problem. For application errors, the element may identify a system the application is dependent upon that failed to respond. For validation errors this may identify the service consumer.
     * 
     * @param source
     */
    public void setSource(HeaderIdentifierSystem source) {
        this.source = source;
    }

    /** 
     * Get the 'System' element value. The system that created the results record. If the Source system identifier is omitted, the system identified here both was the cause of the problem and created the result record.
     * 
     * @return value
     */
    public HeaderIdentifierSystem getSystem() {
        return system;
    }

    /** 
     * Set the 'System' element value. The system that created the results record. If the Source system identifier is omitted, the system identified here both was the cause of the problem and created the result record.
     * 
     * @param system
     */
    public void setSystem(HeaderIdentifierSystem system) {
        this.system = system;
    }

    /** 
     * Get the list of 'SystemSpecificResults' element items.
     * 
     * @return list
     */
    public List<HeaderSystemSpecificResults> getSystemSpecificResultList() {
        return systemSpecificResultList;
    }

    /** 
     * Set the list of 'SystemSpecificResults' element items.
     * 
     * @param list
     */
    public void setSystemSpecificResultList(
            List<HeaderSystemSpecificResults> list) {
        systemSpecificResultList = list;
    }

    /** 
     * Get the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @return value
     */
    public HeaderErrorType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. An indication of the source of error when processing the request.
     * 
     * @param type
     */
    public void setType(HeaderErrorType type) {
        this.type = type;
    }

    /** 
     * Get the 'status' attribute value. Impact of the error on process completion. 
     * 
     * @return value
     */
    public HeaderCompletionCodes getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. Impact of the error on process completion. 
     * 
     * @param status
     */
    public void setStatus(HeaderCompletionCodes status) {
        this.status = status;
    }

    /** 
     * Get the 'timeStamp' attribute value. Error timestamp
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value. Error timestamp
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
