
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Ticketing Standard Payload Header
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.RS">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:Header.Base">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:Header.ResultRecord" name="Results"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderRS extends HeaderBase implements Serializable
{
    private HeaderResultRecord results;

    /** 
     * Get the 'Results' element value. Response message header Results are used to exchange information about the nature of a failure or success. This record must be provided in successful service invocations. May also contain system specific error, result and diagnostic data.
     * 
     * @return value
     */
    public HeaderResultRecord getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value. Response message header Results are used to exchange information about the nature of a failure or success. This record must be provided in successful service invocations. May also contain system specific error, result and diagnostic data.
     * 
     * @param results
     */
    public void setResults(HeaderResultRecord results) {
        this.results = results;
    }
}
