
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Tracking Identifier is an identifier intended for use to a set of related items and provide an optional sequence number for the items. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.TrackingID">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:integer" name="seq"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderTrackingID implements Serializable
{
    private String string;
    private BigInteger seq;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'seq' attribute value.
     * 
     * @return value
     */
    public BigInteger getSeq() {
        return seq;
    }

    /** 
     * Set the 'seq' attribute value.
     * 
     * @param seq
     */
    public void setSeq(BigInteger seq) {
        this.seq = seq;
    }
}
