
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurityTokenCG">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:UsernameToken" name="UsernameToken"/>
 *     &lt;xs:element type="xs:string" name="SecurityToken"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurityTokenCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int USERNAME_TOKEN_CHOICE = 0;
    private static final int SECURITY_TOKEN_CHOICE = 1;
    private UsernameToken usernameToken;
    private String securityToken;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if UsernameToken is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUsernameToken() {
        return choiceSelect == USERNAME_TOKEN_CHOICE;
    }

    /** 
     * Get the 'UsernameToken' element value.
     * 
     * @return value
     */
    public UsernameToken getUsernameToken() {
        return usernameToken;
    }

    /** 
     * Set the 'UsernameToken' element value.
     * 
     * @param usernameToken
     */
    public void setUsernameToken(UsernameToken usernameToken) {
        setChoiceSelect(USERNAME_TOKEN_CHOICE);
        this.usernameToken = usernameToken;
    }

    /** 
     * Check if SecurityToken is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSecurityToken() {
        return choiceSelect == SECURITY_TOKEN_CHOICE;
    }

    /** 
     * Get the 'SecurityToken' element value.
     * 
     * @return value
     */
    public String getSecurityToken() {
        return securityToken;
    }

    /** 
     * Set the 'SecurityToken' element value.
     * 
     * @param securityToken
     */
    public void setSecurityToken(String securityToken) {
        setChoiceSelect(SECURITY_TOKEN_CHOICE);
        this.securityToken = securityToken;
    }
}
