
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingTransactionSource">
 *   &lt;xs:choice minOccurs="1">
 *     &lt;xs:element name="SegmentData" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class SegmentData -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AncillaryServiceData" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class AncillaryServiceData -->
 *     &lt;/xs:element>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingTransactionSource implements Serializable
{
    private int choiceSelect = -1;
    private static final int SEGMENT_DATA_CHOICE = 0;
    private static final int ANCILLARY_SERVICE_DATA_CHOICE = 1;
    private SegmentData segmentData;
    private AncillaryServiceData ancillaryServiceData;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if SegmentData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSegmentData() {
        return choiceSelect == SEGMENT_DATA_CHOICE;
    }

    /** 
     * Get the 'SegmentData' element value.
     * 
     * @return value
     */
    public SegmentData getSegmentData() {
        return segmentData;
    }

    /** 
     * Set the 'SegmentData' element value.
     * 
     * @param segmentData
     */
    public void setSegmentData(SegmentData segmentData) {
        setChoiceSelect(SEGMENT_DATA_CHOICE);
        this.segmentData = segmentData;
    }

    /** 
     * Check if AncillaryServiceData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAncillaryServiceData() {
        return choiceSelect == ANCILLARY_SERVICE_DATA_CHOICE;
    }

    /** 
     * Get the 'AncillaryServiceData' element value.
     * 
     * @return value
     */
    public AncillaryServiceData getAncillaryServiceData() {
        return ancillaryServiceData;
    }

    /** 
     * Set the 'AncillaryServiceData' element value.
     * 
     * @param ancillaryServiceData
     */
    public void setAncillaryServiceData(
            AncillaryServiceData ancillaryServiceData) {
        setChoiceSelect(ANCILLARY_SERVICE_DATA_CHOICE);
        this.ancillaryServiceData = ancillaryServiceData;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentData" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FareComponent" name="FareComponent" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="Segments" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SegmentData implements Serializable
    {
        private FareComponent fareComponent;
        private List<SegmentOrTravelPortion> segmentList = new ArrayList<SegmentOrTravelPortion>();

        /** 
         * Get the 'FareComponent' element value.
         * 
         * @return value
         */
        public FareComponent getFareComponent() {
            return fareComponent;
        }

        /** 
         * Set the 'FareComponent' element value.
         * 
         * @param fareComponent
         */
        public void setFareComponent(FareComponent fareComponent) {
            this.fareComponent = fareComponent;
        }

        /** 
         * Get the list of 'Segments' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortion> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segments' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<SegmentOrTravelPortion> list) {
            segmentList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServiceData" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:group ref="ns:BasicAncillaryServicesDataGroup" minOccurs="1" maxOccurs="1"/>
     *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="Segments" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryServiceData implements Serializable
    {
        private BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup;
        private List<SegmentOrTravelPortion> segmentList = new ArrayList<SegmentOrTravelPortion>();

        /** 
         * Get the 'BasicAncillaryServicesDataGroup' group value.
         * 
         * @return value
         */
        public BasicAncillaryServicesDataGroup getBasicAncillaryServicesDataGroup() {
            return basicAncillaryServicesDataGroup;
        }

        /** 
         * Set the 'BasicAncillaryServicesDataGroup' group value.
         * 
         * @param basicAncillaryServicesDataGroup
         */
        public void setBasicAncillaryServicesDataGroup(
                BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup) {
            this.basicAncillaryServicesDataGroup = basicAncillaryServicesDataGroup;
        }

        /** 
         * Get the list of 'Segments' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortion> getSegmentList() {
            return segmentList;
        }

        /** 
         * Set the list of 'Segments' element items.
         * 
         * @param list
         */
        public void setSegmentList(List<SegmentOrTravelPortion> list) {
            segmentList = list;
        }
    }
}
