
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies passenger numbers and types.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirPriceQualifiersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="SeatsRequested" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="ns:TravelerInformationType" name="AirTravelerAvail" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="ns:PriceRequestOptionsType" name="PriceRequestOptions" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerRatingType" name="TravelerRating" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:GoverningCarrierOverrideType" name="GoverningCarrierOverride" minOccurs="0"/>
 *     &lt;xs:element type="ns:VoluntaryChangesSMPType" name="VoluntaryChanges" minOccurs="0"/>
 *     &lt;xs:element type="ns:RetailerRulesType" name="RetailerRules" minOccurs="0"/>
 *     &lt;xs:element type="ns:TaxRulesType" name="TaxRules" minOccurs="0"/>
 *     &lt;xs:element type="ns:ValidatingCarrierType" name="ValidatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="ns:CabinPrefType" name="CabinPref" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="specificPTC_Indicator"/>
 *   &lt;xs:attribute type="ns:AirTripType" name="tripType"/>
 *   &lt;xs:attribute type="xs:boolean" name="xOFares"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirPriceQualifiersType implements Serializable
{
    private List<BigInteger> seatsRequestedList = new ArrayList<BigInteger>();
    private List<TravelerInformationType> airTravelerAvailList = new ArrayList<TravelerInformationType>();
    private PriceRequestOptionsType priceRequestOptions;
    private List<TravelerRatingType> travelerRatingList = new ArrayList<TravelerRatingType>();
    private GoverningCarrierOverrideType governingCarrierOverride;
    private VoluntaryChangesSMPType voluntaryChanges;
    private RetailerRulesType retailerRules;
    private TaxRulesType taxRules;
    private ValidatingCarrierType validatingCarrier;
    private CabinPrefType cabinPref;
    private Boolean specificPTCIndicator;
    private AirTripType tripType;
    private Boolean XOFares;

    /** 
     * Get the list of 'SeatsRequested' element items. The sum of all seats required by all passenger groups.
                      
     * 
     * @return list
     */
    public List<BigInteger> getSeatsRequestedList() {
        return seatsRequestedList;
    }

    /** 
     * Set the list of 'SeatsRequested' element items. The sum of all seats required by all passenger groups.
                      
     * 
     * @param list
     */
    public void setSeatsRequestedList(List<BigInteger> list) {
        seatsRequestedList = list;
    }

    /** 
     * Get the list of 'AirTravelerAvail' element items. Specifies passenger numbers and types.
     * 
     * @return list
     */
    public List<TravelerInformationType> getAirTravelerAvailList() {
        return airTravelerAvailList;
    }

    /** 
     * Set the list of 'AirTravelerAvail' element items. Specifies passenger numbers and types.
     * 
     * @param list
     */
    public void setAirTravelerAvailList(List<TravelerInformationType> list) {
        airTravelerAvailList = list;
    }

    /** 
     * Get the 'PriceRequestOptions' element value. Identify pricing source, if negotiated fares are requested and if it
                          is a reprice request.
                      
     * 
     * @return value
     */
    public PriceRequestOptionsType getPriceRequestOptions() {
        return priceRequestOptions;
    }

    /** 
     * Set the 'PriceRequestOptions' element value. Identify pricing source, if negotiated fares are requested and if it
                          is a reprice request.
                      
     * 
     * @param priceRequestOptions
     */
    public void setPriceRequestOptions(
            PriceRequestOptionsType priceRequestOptions) {
        this.priceRequestOptions = priceRequestOptions;
    }

    /** 
     * Get the list of 'TravelerRating' element items. Customer Value Scores and Frequent Flyer Tiers for one traveler. It
                          can influence Availability results when provided.
                      
     * 
     * @return list
     */
    public List<TravelerRatingType> getTravelerRatingList() {
        return travelerRatingList;
    }

    /** 
     * Set the list of 'TravelerRating' element items. Customer Value Scores and Frequent Flyer Tiers for one traveler. It
                          can influence Availability results when provided.
                      
     * 
     * @param list
     */
    public void setTravelerRatingList(List<TravelerRatingType> list) {
        travelerRatingList = list;
    }

    /** 
     * Get the 'GoverningCarrierOverride' element value. Airline Carrier Code - override the GOVERNING CARRIER to get the fare filed by that carrier.
                      
     * 
     * @return value
     */
    public GoverningCarrierOverrideType getGoverningCarrierOverride() {
        return governingCarrierOverride;
    }

    /** 
     * Set the 'GoverningCarrierOverride' element value. Airline Carrier Code - override the GOVERNING CARRIER to get the fare filed by that carrier.
                      
     * 
     * @param governingCarrierOverride
     */
    public void setGoverningCarrierOverride(
            GoverningCarrierOverrideType governingCarrierOverride) {
        this.governingCarrierOverride = governingCarrierOverride;
    }

    /** 
     * Get the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
     * 
     * @return value
     */
    public VoluntaryChangesSMPType getVoluntaryChanges() {
        return voluntaryChanges;
    }

    /** 
     * Set the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
     * 
     * @param voluntaryChanges
     */
    public void setVoluntaryChanges(VoluntaryChangesSMPType voluntaryChanges) {
        this.voluntaryChanges = voluntaryChanges;
    }

    /** 
     * Get the 'RetailerRules' element value. TBD.
     * 
     * @return value
     */
    public RetailerRulesType getRetailerRules() {
        return retailerRules;
    }

    /** 
     * Set the 'RetailerRules' element value. TBD.
     * 
     * @param retailerRules
     */
    public void setRetailerRules(RetailerRulesType retailerRules) {
        this.retailerRules = retailerRules;
    }

    /** 
     * Get the 'TaxRules' element value. Contains tax depending rules.
     * 
     * @return value
     */
    public TaxRulesType getTaxRules() {
        return taxRules;
    }

    /** 
     * Set the 'TaxRules' element value. Contains tax depending rules.
     * 
     * @param taxRules
     */
    public void setTaxRules(TaxRulesType taxRules) {
        this.taxRules = taxRules;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating carrier rule.
     * 
     * @return value
     */
    public ValidatingCarrierType getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating carrier rule.
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(ValidatingCarrierType validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'CabinPref' element value. Defines preferred cabin to be used in a search for this leg level (if SegmentType is "O") or segment (if SegmentType is "X"). The cabin type specified in this element will override the cabin type specified at the request level for this leg/segment. If a cabin type is not specified for this element the cabin type at request level will be used as default for this leg or segment. If the cabin type is not specified at both the leg/segment level and request level a default cabin of "Economy" will be used?
     * 
     * @return value
     */
    public CabinPrefType getCabinPref() {
        return cabinPref;
    }

    /** 
     * Set the 'CabinPref' element value. Defines preferred cabin to be used in a search for this leg level (if SegmentType is "O") or segment (if SegmentType is "X"). The cabin type specified in this element will override the cabin type specified at the request level for this leg/segment. If a cabin type is not specified for this element the cabin type at request level will be used as default for this leg or segment. If the cabin type is not specified at both the leg/segment level and request level a default cabin of "Economy" will be used?
     * 
     * @param cabinPref
     */
    public void setCabinPref(CabinPrefType cabinPref) {
        this.cabinPref = cabinPref;
    }

    /** 
     * Get the 'specificPTC_Indicator' attribute value. If true, this request is for a specific PTC and only fares applicable to
                      that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
                  
     * 
     * @return value
     */
    public Boolean getSpecificPTCIndicator() {
        return specificPTCIndicator;
    }

    /** 
     * Set the 'specificPTC_Indicator' attribute value. If true, this request is for a specific PTC and only fares applicable to
                      that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
                  
     * 
     * @param specificPTCIndicator
     */
    public void setSpecificPTCIndicator(Boolean specificPTCIndicator) {
        this.specificPTCIndicator = specificPTCIndicator;
    }

    /** 
     * Get the 'tripType' attribute value. Specify air trip type.
     * 
     * @return value
     */
    public AirTripType getTripType() {
        return tripType;
    }

    /** 
     * Set the 'tripType' attribute value. Specify air trip type.
     * 
     * @param tripType
     */
    public void setTripType(AirTripType tripType) {
        this.tripType = tripType;
    }

    /** 
     * Get the 'xOFares' attribute value. XOFares indicator
     * 
     * @return value
     */
    public Boolean getXOFares() {
        return XOFares;
    }

    /** 
     * Set the 'xOFares' attribute value. XOFares indicator
     * 
     * @param xOFares
     */
    public void setXOFares(Boolean xOFares) {
        XOFares = xOFares;
    }
}
