
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IndicatorsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:IndRequiredType" name="RetainFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="MinMaxStay" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="RefundPenalty" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="ResTicketing" minOccurs="0"/>
 *     &lt;xs:element type="ns:IndRequiredType" name="TravelPolicy" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IndicatorsType implements Serializable
{
    private IndRequiredType retainFare;
    private IndRequiredType minMaxStay;
    private IndRequiredType refundPenalty;
    private IndRequiredType resTicketing;
    private IndRequiredType travelPolicy;

    /** 
     * Get the 'RetainFare' element value. Currently must be set to true.
     * 
     * @return value
     */
    public IndRequiredType getRetainFare() {
        return retainFare;
    }

    /** 
     * Set the 'RetainFare' element value. Currently must be set to true.
     * 
     * @param retainFare
     */
    public void setRetainFare(IndRequiredType retainFare) {
        this.retainFare = retainFare;
    }

    /** 
     * Get the 'MinMaxStay' element value. If set to true, fares that have a min/max stay can be included in the
                          responses. If set to false, then no fares that include a min/max stay requirement
                          will be included in the response.
                      
     * 
     * @return value
     */
    public IndRequiredType getMinMaxStay() {
        return minMaxStay;
    }

    /** 
     * Set the 'MinMaxStay' element value. If set to true, fares that have a min/max stay can be included in the
                          responses. If set to false, then no fares that include a min/max stay requirement
                          will be included in the response.
                      
     * 
     * @param minMaxStay
     */
    public void setMinMaxStay(IndRequiredType minMaxStay) {
        this.minMaxStay = minMaxStay;
    }

    /** 
     * Get the 'RefundPenalty' element value. If set to true, fares that have a refund penalty can be included in
                          the responses. If set to false, then no fares that include a refund penalty
                          requirement will be included in the response.
                      
     * 
     * @return value
     */
    public IndRequiredType getRefundPenalty() {
        return refundPenalty;
    }

    /** 
     * Set the 'RefundPenalty' element value. If set to true, fares that have a refund penalty can be included in
                          the responses. If set to false, then no fares that include a refund penalty
                          requirement will be included in the response.
                      
     * 
     * @param refundPenalty
     */
    public void setRefundPenalty(IndRequiredType refundPenalty) {
        this.refundPenalty = refundPenalty;
    }

    /** 
     * Get the 'ResTicketing' element value. If set to true, fares that have a reservation/ticketing can be
                          included in the responses. If set to false, then no fares that include
                          reservation/ticketing requirement will be included in the response.
                      
     * 
     * @return value
     */
    public IndRequiredType getResTicketing() {
        return resTicketing;
    }

    /** 
     * Set the 'ResTicketing' element value. If set to true, fares that have a reservation/ticketing can be
                          included in the responses. If set to false, then no fares that include
                          reservation/ticketing requirement will be included in the response.
                      
     * 
     * @param resTicketing
     */
    public void setResTicketing(IndRequiredType resTicketing) {
        this.resTicketing = resTicketing;
    }

    /** 
     * Get the 'TravelPolicy' element value. This element is currently ignored whether it is true or false.
                      
     * 
     * @return value
     */
    public IndRequiredType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. This element is currently ignored whether it is true or false.
                      
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(IndRequiredType travelPolicy) {
        this.travelPolicy = travelPolicy;
    }
}
